/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Functions;
import hudson.model.TaskListener;
import jenkins.model.CauseOfInterruption;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class RetryStepExecution
extends AbstractStepExecutionImpl {
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
    private final transient int count;
    private volatile BodyExecution body;
    private static final long serialVersionUID = 1L;

    RetryStepExecution(int count, StepContext context) {
        super(context);
        this.count = count;
    }

    public boolean start() throws Exception {
        StepContext context = this.getContext();
        this.body = context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(this.count)).start();
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        if (this.body != null) {
            this.body.cancel(cause);
        }
    }

    public void onResume() {
    }

    private static class Callback
    extends BodyExecutionCallback {
        private int left;
        private static final long serialVersionUID = 1L;

        Callback(int count) {
            this.left = count;
        }

        public void onSuccess(StepContext context, Object result) {
            context.onSuccess(result);
        }

        public void onFailure(StepContext context, Throwable t) {
            try {
                if (t instanceof FlowInterruptedException) {
                    for (CauseOfInterruption cause : ((FlowInterruptedException)t).getCauses()) {
                        if (!(cause instanceof CauseOfInterruption.UserInterruption)) continue;
                        context.onFailure(t);
                        return;
                    }
                }
                --this.left;
                if (this.left > 0) {
                    TaskListener l = (TaskListener)context.get(TaskListener.class);
                    if (t instanceof AbortException) {
                        l.error(t.getMessage());
                    } else {
                        l.error("Execution failed").println(Functions.printThrowable((Throwable)t).trim());
                    }
                    l.getLogger().println("Retrying");
                    context.newBodyInvoker().withCallback((BodyExecutionCallback)this).start();
                } else {
                    context.onFailure(t);
                }
            }
            catch (Throwable p) {
                context.onFailure(p);
            }
        }
    }
}

