/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.base.Function;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public final class WaitForConditionStep
extends Step {
    @DataBoundConstructor
    public WaitForConditionStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "waitUntil";
        }

        public String getDisplayName() {
            return "Wait for condition";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }

    private static final class Callback
    extends BodyExecutionCallback {
        private static final long serialVersionUID = 1L;
        private final String id;

        Callback(String id) {
            this.id = id;
        }

        public void onSuccess(StepContext context, Object result) {
            if (!(result instanceof Boolean)) {
                context.onFailure((Throwable)new ClassCastException("body return value " + result + " is not boolean"));
                return;
            }
            if (((Boolean)result).booleanValue()) {
                context.onSuccess(null);
                return;
            }
            Execution.retry(this.id, context);
        }

        public void onFailure(StepContext context, Throwable t) {
            context.onFailure(t);
        }
    }

    public static final class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        private volatile BodyExecution body;
        private volatile transient ScheduledFuture<?> task;
        private final String id = UUID.randomUUID().toString();
        private static final float RECURRENCE_PERIOD_BACKOFF = 1.2f;
        static final long MIN_RECURRENCE_PERIOD = 250L;
        static final long MAX_RECURRENCE_PERIOD = 15000L;
        long recurrencePeriod = 250L;

        Execution(StepContext context) {
            super(context);
        }

        public boolean start() throws Exception {
            this.body = this.getContext().newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(this.id)).start();
            return false;
        }

        public void stop(Throwable cause) throws Exception {
            if (this.body != null) {
                this.body.cancel(cause);
            }
            if (this.task != null) {
                this.task.cancel(false);
                this.getContext().onFailure(cause);
            }
        }

        public void onResume() {
            this.recurrencePeriod = 250L;
            if (this.body == null) {
                this.body = this.getContext().newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(this.id)).start();
            }
        }

        private static void retry(final String id, final StepContext context) {
            StepExecution.applyAll(Execution.class, (Function)new Function<Execution, Void>(){

                public Void apply(@Nonnull Execution execution) {
                    if (execution.id.equals(id)) {
                        execution.retry(context);
                    }
                    return null;
                }
            });
        }

        private void retry(StepContext perBodyContext) {
            this.body = null;
            this.getContext().saveState();
            try {
                ((TaskListener)perBodyContext.get(TaskListener.class)).getLogger().println("Will try again after " + Util.getTimeSpanString((long)this.recurrencePeriod));
            }
            catch (Exception x) {
                this.getContext().onFailure((Throwable)x);
                return;
            }
            this.task = Timer.get().schedule(new Runnable(){

                @Override
                public void run() {
                    Execution.this.task = null;
                    Execution.this.body = Execution.this.getContext().newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(Execution.this.id)).start();
                }
            }, this.recurrencePeriod, TimeUnit.MILLISECONDS);
            this.recurrencePeriod = Math.min((long)((float)this.recurrencePeriod * 1.2f), 15000L);
        }

        public String getStatus() {
            if (this.body != null) {
                return "running body";
            }
            if (this.task == null) {
                return "no body, no task, not sure what happened";
            }
            if (this.task.isDone()) {
                return "scheduled task task done, but no body";
            }
            if (this.task.isCancelled()) {
                return "scheduled task was cancelled";
            }
            return "waiting to rerun; next recurrence period: " + this.recurrencePeriod + "ms";
        }
    }
}

