/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.LauncherDecorator;
import hudson.console.ConsoleLogFilter;
import java.util.Collections;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class WithContextStep
extends Step {
    public final Object context;

    @DataBoundConstructor
    public WithContextStep(Object context) {
        this.context = context;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this.context, context);
    }

    public static class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private transient Object obj;

        Execution(Object obj, StepContext context) {
            super(context);
            this.obj = obj;
        }

        public boolean start() throws Exception {
            StepContext context = this.getContext();
            if (this.obj instanceof ConsoleLogFilter) {
                this.obj = BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)((ConsoleLogFilter)context.get(ConsoleLogFilter.class)), (ConsoleLogFilter)((ConsoleLogFilter)this.obj));
            } else if (this.obj instanceof LauncherDecorator) {
                this.obj = BodyInvoker.mergeLauncherDecorators((LauncherDecorator)((LauncherDecorator)context.get(LauncherDecorator.class)), (LauncherDecorator)((LauncherDecorator)this.obj));
            } else if (this.obj instanceof EnvironmentExpander) {
                this.obj = EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)context.get(EnvironmentExpander.class)), (EnvironmentExpander)((EnvironmentExpander)this.obj));
            }
            context.newBodyInvoker().withContext(this.obj).withCallback(BodyExecutionCallback.wrap((FutureCallback)context)).start();
            return false;
        }

        public void stop(Throwable cause) throws Exception {
            this.getContext().onFailure(cause);
        }

        public void onResume() {
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "withContext";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public String getDisplayName() {
            return "Use contextual object from internal APIs within a block";
        }

        public boolean isAdvanced() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.emptySet();
        }
    }
}

