/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.RelativePath;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.libs.LibraryResolver;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;

public class LibraryConfiguration
extends AbstractDescribableImpl<LibraryConfiguration> {
    private final String name;
    private final LibraryRetriever retriever;
    private String defaultVersion;
    private boolean implicit;
    private boolean allowVersionOverride = true;

    @DataBoundConstructor
    public LibraryConfiguration(String name, LibraryRetriever retriever) {
        this.name = name;
        this.retriever = retriever;
    }

    public String getName() {
        return this.name;
    }

    public LibraryRetriever getRetriever() {
        return this.retriever;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    @DataBoundSetter
    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = Util.fixEmpty((String)defaultVersion);
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    @DataBoundSetter
    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isAllowVersionOverride() {
        return this.allowVersionOverride;
    }

    @DataBoundSetter
    public void setAllowVersionOverride(boolean allowVersionOverride) {
        this.allowVersionOverride = allowVersionOverride;
    }

    @Nonnull
    String defaultedVersion(@CheckForNull String version) throws AbortException {
        if (version == null) {
            if (this.defaultVersion == null) {
                throw new AbortException("No version specified for library " + this.name);
            }
            return this.defaultVersion;
        }
        if (this.allowVersionOverride) {
            return version;
        }
        throw new AbortException("Version override not permitted for library " + this.name);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<LibraryConfiguration> {
        public FormValidation doCheckName(@QueryParameter String name, @QueryParameter @RelativePath(value="scm") String id) {
            if (name.isEmpty()) {
                return FormValidation.error((String)"You must enter a name.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDefaultVersion(@QueryParameter String defaultVersion, @QueryParameter boolean implicit, @QueryParameter boolean allowVersionOverride, @QueryParameter String name) {
            if (defaultVersion.isEmpty()) {
                if (implicit) {
                    return FormValidation.error((String)"If you load a library implicitly, you must specify a default version.");
                }
                if (!allowVersionOverride) {
                    return FormValidation.error((String)"If you deny overriding a default version, you must define that version.");
                }
                return FormValidation.ok();
            }
            for (LibraryResolver resolver : ExtensionList.lookup(LibraryResolver.class)) {
                for (LibraryConfiguration config : resolver.fromConfiguration(Stapler.getCurrentRequest())) {
                    if (!config.getName().equals(name)) continue;
                    return config.getRetriever().validateVersion(name, defaultVersion);
                }
            }
            return FormValidation.ok((String)"Cannot validate default version until after saving and reconfiguring.");
        }
    }
}

