/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import hudson.AbortException;
import hudson.Extension;
import java.util.Map;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.libs.LibraryAdder;
import org.jenkinsci.plugins.workflow.libs.Messages;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class ResourceStep
extends AbstractStepImpl {
    private final String resource;

    @DataBoundConstructor
    public ResourceStep(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<String> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient ResourceStep step;

        protected String run() throws Exception {
            String resource = this.step.resource;
            Map<String, String> contents = LibraryAdder.findResources((CpsFlowExecution)this.getContext().get(FlowExecution.class), resource);
            if (contents.isEmpty()) {
                throw new AbortException(Messages.ResourceStep_no_such_library_resource_could_be_found_(resource));
            }
            if (contents.size() == 1) {
                return contents.values().iterator().next();
            }
            throw new AbortException(Messages.ResourceStep_library_resource_ambiguous_among_librari(resource, contents.keySet()));
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getDisplayName() {
            return "Load a resource file from a shared library";
        }

        public String getFunctionName() {
            return "libraryResource";
        }
    }
}

