/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Items;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.LibraryRetrieverDescriptor;
import org.jenkinsci.plugins.workflow.libs.SCMSourceRetriever;
import org.kohsuke.stapler.DataBoundConstructor;

public class SCMRetriever
extends LibraryRetriever {
    private final SCM scm;

    @DataBoundConstructor
    public SCMRetriever(SCM scm) {
        this.scm = scm;
    }

    public SCM getScm() {
        return this.scm;
    }

    @Override
    public void retrieve(String name, String version, FilePath target, Run<?, ?> run, TaskListener listener) throws Exception {
        SCMSourceRetriever.doRetrieve(this.scm, target, run, listener);
    }

    @Override
    public FormValidation validateVersion(String name, String version) {
        if (!Items.XSTREAM2.toXML((Object)this.scm).contains("${library." + name + ".version}")) {
            return FormValidation.warningWithMarkup((String)("When using <b>" + this.getDescriptor().getDisplayName() + "</b>, you will need to include <code>${library." + Util.escape((String)name) + ".version}</code> in the SCM configuration somewhere."));
        }
        return FormValidation.okWithMarkup((String)("Cannot validate default version with legacy SCM plugins via <b>" + this.getDescriptor().getDisplayName() + "</b>. Use " + ((SCMSourceRetriever.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(SCMSourceRetriever.DescriptorImpl.class)).getDisplayName() + " if available."));
    }

    @Extension(ordinal=-100.0)
    public static class DescriptorImpl
    extends LibraryRetrieverDescriptor {
        public String getDisplayName() {
            return "Legacy SCM";
        }

        public static List<SCMDescriptor<?>> getSCMDescriptors() {
            ArrayList descriptors = new ArrayList();
            for (SCMDescriptor d : SCM.all()) {
                if (d.clazz == NullSCM.class) continue;
                descriptors.add(d);
            }
            return descriptors;
        }
    }
}

