/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.SerializableScript;
import groovy.lang.GroovyShell;
import hudson.model.Queue;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.DSL;
import org.jenkinsci.plugins.workflow.cps.EnvActionImpl;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;

public abstract class CpsScript
extends SerializableScript {
    private static final Logger LOGGER = Logger.getLogger(CpsScript.class.getName());
    private static final String STEPS_VAR = "steps";
    transient CpsFlowExecution execution;
    private static final long serialVersionUID = 1L;

    public CpsScript() throws IOException {
        CpsThread c = CpsThread.current();
        if (c != null) {
            this.execution = c.getExecution();
            this.$initialize();
        }
    }

    final void $initialize() throws IOException {
        this.getBinding().setVariable(STEPS_VAR, (Object)new DSL(this.execution.getOwner()));
    }

    public final Object invokeMethod(String name, Object args) {
        GlobalVariable v = GlobalVariable.byName(name, this.$buildNoException());
        if (v != null) {
            try {
                Object o = v.getValue(this);
                return InvokerHelper.getMetaClass((Object)o).invokeMethod(o, "call", args);
            }
            catch (Exception x) {
                throw new InvokerInvocationException((Throwable)x);
            }
        }
        DSL dsl = (DSL)this.getBinding().getVariable(STEPS_VAR);
        return dsl.invokeMethod(name, args);
    }

    public Object getProperty(String property) {
        Run<?, ?> b = this.$buildNoException();
        GlobalVariable v = GlobalVariable.byName(property, b);
        if (v != null) {
            try {
                return v.getValue(this);
            }
            catch (Exception x) {
                throw new InvokerInvocationException((Throwable)x);
            }
        }
        if (b != null) {
            try {
                String value = EnvActionImpl.forRun(b).getProperty(property);
                if (value != null) {
                    return value;
                }
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
        return super.getProperty(property);
    }

    @CheckForNull
    public Run<?, ?> $build() throws IOException {
        FlowExecutionOwner owner = this.execution.getOwner();
        Queue.Executable qe = owner.getExecutable();
        if (qe instanceof Run) {
            return (Run)qe;
        }
        return null;
    }

    @CheckForNull
    public Run<?, ?> $buildNoException() {
        if (this.execution == null) {
            return null;
        }
        try {
            return this.$build();
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
            return null;
        }
    }

    public Object evaluate(String script) throws CompilationFailedException {
        return this.$getShell().evaluate(script);
    }

    public Object evaluate(File file) throws CompilationFailedException, IOException {
        return this.$getShell().evaluate(file);
    }

    public void run(File file, String[] arguments) throws CompilationFailedException, IOException {
        this.$getShell().run(file, arguments);
    }

    private GroovyShell $getShell() {
        return CpsThreadGroup.current().getExecution().getShell();
    }

    protected Object readResolve() {
        this.execution = CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.get();
        assert (this.execution != null);
        return this;
    }

    public void println() {
        this.invokeMethod("echo", "");
    }

    public void print(Object value) {
        this.println(value);
    }

    public void println(Object value) {
        this.invokeMethod("echo", String.valueOf(value));
    }

    public void printf(String format, Object value) {
        this.print(DefaultGroovyMethods.sprintf((Object)((Object)this), (String)format, (Object)value));
    }

    public void printf(String format, Object[] values) {
        this.print(DefaultGroovyMethods.sprintf((Object)((Object)this), (String)format, (Object[])values));
    }

    @Whitelisted
    public Object sleep(long arg) {
        return this.invokeMethod("sleep", arg);
    }
}

