/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Outcome;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Result;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.cps.BodyReference;
import org.jenkinsci.plugins.workflow.cps.ContextVariableSet;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadDump;
import org.jenkinsci.plugins.workflow.cps.CpsVmExecutorService;
import org.jenkinsci.plugins.workflow.cps.CpsVmThreadOnly;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.cps.StaticBodyReference;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.RiverWriter;

@SuppressWarnings(value={"SE_BAD_FIELD"})
public final class CpsThreadGroup
implements Serializable {
    private transient CpsFlowExecution execution;
    final NavigableMap<Integer, CpsThread> threads = new TreeMap<Integer, CpsThread>();
    private int iota;
    transient ExecutorService runner;
    transient boolean busy;
    private AtomicBoolean paused = new AtomicBoolean();
    public final Map<Integer, Closure> closures = new HashMap<Integer, Closure>();
    private final List<Script> scripts = new ArrayList<Script>();
    private transient List<FlowNode> nodesToNotify;
    private static final Object nodesToNotifyLock = new Object();
    private static final Logger LOGGER = Logger.getLogger(CpsThreadGroup.class.getName());
    private static final long serialVersionUID = 1L;

    CpsThreadGroup(CpsFlowExecution execution) {
        this.execution = execution;
        this.setupTransients();
    }

    public CpsFlowExecution getExecution() {
        return this.execution;
    }

    void register(Script script) {
        this.scripts.add(script);
    }

    private Object readResolve() {
        this.execution = CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.get();
        this.setupTransients();
        assert (this.execution != null);
        if (this.scripts != null) {
            GroovyShell shell = this.execution.getShell();
            assert (shell.getContext().getVariables().isEmpty());
            assert (!this.scripts.isEmpty());
            shell.getContext().getVariables().putAll(this.scripts.get(0).getBinding().getVariables());
            for (Script script : this.scripts) {
                if (!script.getBinding().getVariables().equals(shell.getContext().getVariables())) continue;
                script.setBinding(shell.getContext());
            }
        }
        return this;
    }

    private void setupTransients() {
        this.runner = new CpsVmExecutorService(this);
        if (this.paused == null) {
            this.paused = new AtomicBoolean();
        }
    }

    @CpsVmThreadOnly
    public CpsThread addThread(Continuable program, FlowHead head, ContextVariableSet contextVariables) {
        this.assertVmThread();
        CpsThread t = new CpsThread(this, this.iota++, program, head, contextVariables);
        this.threads.put(t.id, t);
        return t;
    }

    private void assertVmThread() {
        assert (CpsThreadGroup.current() == this);
    }

    public CpsThread getThread(int id) {
        return (CpsThread)this.threads.get(id);
    }

    @Nonnull
    @CpsVmThreadOnly(value="root")
    public BodyReference export(@Nonnull Closure body) {
        this.assertVmThread();
        int id = this.iota++;
        this.closures.put(id, body);
        return new StaticBodyReference(id, body);
    }

    @Nonnull
    @CpsVmThreadOnly(value="root")
    public BodyReference export(final @Nonnull Script body) {
        this.register(body);
        return this.export(new Closure(null){

            public Object call() {
                return body.run();
            }
        });
    }

    @CpsVmThreadOnly(value="root")
    public void unexport(BodyReference ref) {
        this.assertVmThread();
        if (ref == null) {
            return;
        }
        this.closures.remove(ref.id);
    }

    public Future<?> scheduleRun() {
        final SettableFuture f = SettableFuture.create();
        try {
            this.runner.submit(new Callable<Void>(){

                @Override
                @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
                public Void call() throws Exception {
                    Jenkins j = Jenkins.getInstance();
                    if (CpsThreadGroup.this.paused.get() || j == null || j.isQuietingDown()) {
                        CpsThreadGroup.this.saveProgram();
                        f.set(null);
                        return null;
                    }
                    boolean stillRunnable = CpsThreadGroup.this.run();
                    try {
                        if (stillRunnable) {
                            CpsThreadGroup.this.runner.submit(this);
                        } else {
                            CpsThreadGroup.this.runner.submit(new Runnable(){

                                @Override
                                public void run() {
                                    if (CpsThreadGroup.this.threads.isEmpty()) {
                                        CpsThreadGroup.this.runner.shutdown();
                                    }
                                    f.set(null);
                                }
                            });
                        }
                    }
                    catch (RejectedExecutionException x) {
                        f.setException((Throwable)x);
                    }
                    return null;
                }
            });
        }
        catch (RejectedExecutionException x) {
            return Futures.immediateFuture(null);
        }
        return f;
    }

    public Future<?> pause() {
        this.paused.set(true);
        return this.scheduleRun();
    }

    public void unpause() {
        if (this.paused.getAndSet(false)) {
            this.scheduleRun();
        } else {
            LOGGER.warning("were not paused to begin with");
        }
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    @CpsVmThreadOnly(value="root")
    private boolean run() throws IOException {
        boolean changed = false;
        boolean ending = false;
        boolean stillRunnable = false;
        for (CpsThread t : this.threads.values().toArray(new CpsThread[this.threads.size()])) {
            if (!t.isRunnable()) continue;
            Outcome o = t.runNextChunk();
            if (o.isFailure()) {
                assert (!t.isAlive());
                Result result = Result.FAILURE;
                Throwable error = o.getAbnormal();
                if (error instanceof FlowInterruptedException) {
                    result = ((FlowInterruptedException)error).getResult();
                }
                this.execution.setResult(result);
                t.head.get().addAction((Action)new ErrorAction(error));
            }
            if (!t.isAlive()) {
                LOGGER.fine("completed " + t);
                t.fireCompletionHandlers(o);
                this.threads.remove(t.id);
                if (this.threads.isEmpty()) {
                    this.execution.onProgramEnd(o);
                    ending = true;
                }
            } else {
                stillRunnable |= t.isRunnable();
            }
            changed = true;
        }
        if (changed) {
            this.saveProgram();
        }
        if (ending) {
            this.execution.cleanUpHeap();
            this.scripts.clear();
        }
        return stillRunnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CpsVmThreadOnly
    void notifyNewHead(FlowNode head) {
        this.assertVmThread();
        this.execution.notifyListeners(Collections.singletonList(head), true);
        Object object = nodesToNotifyLock;
        synchronized (object) {
            if (this.nodesToNotify == null) {
                this.nodesToNotify = new ArrayList<FlowNode>();
            }
            this.nodesToNotify.add(head);
        }
        this.runner.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List _nodesToNotify;
                Object object = nodesToNotifyLock;
                synchronized (object) {
                    if (CpsThreadGroup.this.nodesToNotify == null) {
                        return;
                    }
                    _nodesToNotify = CpsThreadGroup.this.nodesToNotify;
                    CpsThreadGroup.this.nodesToNotify = null;
                }
                CpsThreadGroup.this.execution.notifyListeners(_nodesToNotify, false);
            }
        });
    }

    public CpsThreadDump getThreadDump() {
        return CpsThreadDump.from(this);
    }

    @CpsVmThreadOnly
    void saveProgram() throws IOException {
        File f = this.execution.getProgramDataFile();
        this.saveProgram(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CpsVmThreadOnly
    public void saveProgram(File f) throws IOException {
        File dir = f.getParentFile();
        File tmpFile = File.createTempFile("atomic", null, dir);
        this.assertVmThread();
        CpsFlowExecution old = CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.get();
        CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.set(this.execution);
        if (Jenkins.getInstance() == null) {
            LOGGER.log(Level.WARNING, "Skipping save to {0} since Jenkins seems to be shutting down", f);
            return;
        }
        try {
            try (RiverWriter w = new RiverWriter(tmpFile, this.execution.getOwner());){
                w.writeObject((Object)this);
            }
            Files.move(tmpFile.toPath(), f.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            LOGGER.log(Level.FINE, "program state saved");
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "program state save failed", e);
            this.propagateErrorToWorkflow(e);
            throw new IOException("Failed to persist " + f, e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "program state save failed", e);
            this.propagateErrorToWorkflow(e);
            throw new IOException("Failed to persist " + f, e);
        }
        finally {
            CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.set(old);
            Util.deleteFile((File)tmpFile);
        }
    }

    @CpsVmThreadOnly
    private void propagateErrorToWorkflow(Throwable t) {
        Map.Entry<Integer, CpsThread> lastEntry = this.threads.lastEntry();
        if (lastEntry != null) {
            lastEntry.getValue().resume(new Outcome(null, t));
        } else {
            LOGGER.log(Level.WARNING, "encountered error but could not pass it to the flow", t);
        }
    }

    @CpsVmThreadOnly
    static CpsThreadGroup current() {
        return CpsVmExecutorService.CURRENT.get();
    }
}

