/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import hudson.Extension;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.pickles.PickleFactory;

@Extension
public class ParamsVariable
extends GlobalVariable {
    @Override
    public String getName() {
        return "params";
    }

    @Override
    public Object getValue(CpsScript script) throws Exception {
        List parameterValues;
        Run<?, ?> b = script.$build();
        if (b == null) {
            throw new IllegalStateException("cannot find owning build");
        }
        ParametersAction action = (ParametersAction)b.getAction(ParametersAction.class);
        if (action == null) {
            return Collections.emptyMap();
        }
        try {
            parameterValues = (List)ParametersAction.class.getMethod("getAllParameters", new Class[0]).invoke((Object)action, new Object[0]);
        }
        catch (NoSuchMethodException x) {
            parameterValues = action.getParameters();
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (ParameterValue parameterValue : parameterValues) {
            Object value = parameterValue.getValue();
            if (!(value instanceof Serializable)) {
                boolean canPickle = false;
                for (PickleFactory pf : PickleFactory.all()) {
                    if (pf.writeReplace(value) == null) continue;
                    canPickle = true;
                    break;
                }
                if (!canPickle) continue;
            }
            values.put(parameterValue.getName(), value);
        }
        return values;
    }
}

