/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.CpsTransformer;
import com.cloudbees.groovy.cps.NonCPS;
import com.cloudbees.groovy.cps.SandboxCpsTransformer;
import com.cloudbees.groovy.cps.TransformerConfiguration;
import groovy.lang.Binding;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.IOException;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.workflow.cps.CpsClosure2;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.GroovyShellDecorator;

class CpsGroovyShell
extends GroovyShell {
    @CheckForNull
    private final CpsFlowExecution execution;

    CpsGroovyShell(@CheckForNull CpsFlowExecution execution) {
        super(CpsGroovyShell.makeClassLoader(), new Binding(), CpsGroovyShell.makeConfig(execution));
        this.execution = execution;
        for (GroovyShellDecorator d : GroovyShellDecorator.all()) {
            d.configureShell(execution, this);
        }
    }

    private static ClassLoader makeClassLoader() {
        Jenkins j = Jenkins.getInstance();
        ClassLoader cl = j != null ? j.getPluginManager().uberClassLoader : CpsGroovyShell.class.getClassLoader();
        return GroovySandbox.createSecureClassLoader((ClassLoader)cl);
    }

    private static CompilerConfiguration makeConfig(@CheckForNull CpsFlowExecution execution) {
        ImportCustomizer ic = new ImportCustomizer();
        ic.addStarImports(new String[]{NonCPS.class.getPackage().getName()});
        ic.addStarImports(new String[]{"hudson.model", "jenkins.model"});
        for (GroovyShellDecorator d : GroovyShellDecorator.all()) {
            d.customizeImports(execution, ic);
        }
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{ic});
        cc.addCompilationCustomizers(new CompilationCustomizer[]{CpsGroovyShell.makeCpsTransformer(execution)});
        cc.setScriptBaseClass(CpsScript.class.getName());
        for (GroovyShellDecorator d : GroovyShellDecorator.all()) {
            d.configureCompiler(execution, cc);
        }
        return cc;
    }

    private static CpsTransformer makeCpsTransformer(CpsFlowExecution execution) {
        CpsTransformer t = execution != null && execution.isSandbox() ? new SandboxCpsTransformer() : new CpsTransformer();
        t.setConfiguration(new TransformerConfiguration().withClosureType(CpsClosure2.class));
        return t;
    }

    public void prepareScript(Script script) {
        if (script instanceof CpsScript) {
            CpsScript cs = (CpsScript)script;
            cs.execution = this.execution;
            try {
                cs.$initialize();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Script parse(GroovyCodeSource codeSource) throws CompilationFailedException {
        Script s = super.parse(codeSource);
        if (this.execution != null) {
            this.execution.loadedScripts.put(s.getClass().getName(), codeSource.getScriptText());
        }
        this.prepareScript(s);
        return s;
    }

    Script reparse(String className, String text) throws CompilationFailedException {
        return super.parse(new GroovyCodeSource(text, className, "/groovy/shell"));
    }

    protected synchronized String generateScriptName() {
        if (this.execution != null) {
            return "Script" + (this.execution.loadedScripts.size() + 1) + ".groovy";
        }
        return super.generateScriptName();
    }
}

