/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Outcome;
import java.util.concurrent.Callable;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsWhitelist;
import org.jenkinsci.plugins.workflow.cps.GroovyClassLoaderWhitelist;

class SandboxContinuable
extends Continuable {
    private final CpsThread thread;

    SandboxContinuable(Continuable src, CpsThread thread) {
        super(src);
        this.thread = thread;
    }

    public Outcome run0(final Outcome cn) {
        try {
            return (Outcome)GroovySandbox.runInSandbox((Callable)new Callable<Outcome>(){

                @Override
                public Outcome call() {
                    Outcome outcome = SandboxContinuable.super.run0(cn);
                    RejectedAccessException x = SandboxContinuable.findRejectedAccessException(outcome.getAbnormal());
                    if (x != null) {
                        ScriptApproval.get().accessRejected(x, ApprovalContext.create());
                    }
                    return outcome;
                }
            }, (Whitelist)new ProxyWhitelist(new Whitelist[]{new GroovyClassLoaderWhitelist(this.thread.group.getExecution().getShell().getClassLoader()), CpsWhitelist.get()}));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @CheckForNull
    private static RejectedAccessException findRejectedAccessException(@CheckForNull Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof RejectedAccessException) {
            return (RejectedAccessException)t;
        }
        return SandboxContinuable.findRejectedAccessException(t.getCause());
    }
}

