/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.Outcome;
import com.cloudbees.groovy.cps.impl.CpsCallableInvocation;
import com.cloudbees.groovy.cps.impl.FunctionCallEnv;
import com.cloudbees.groovy.cps.impl.TryBlockEnv;
import com.cloudbees.groovy.cps.sandbox.Invoker;
import com.cloudbees.groovy.cps.sandbox.SandboxInvoker;
import com.google.common.util.concurrent.FutureCallback;
import hudson.model.Action;
import hudson.model.Result;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jenkins.model.CauseOfInterruption;
import org.jenkinsci.plugins.workflow.actions.BodyInvocationAction;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.cps.ContextVariableSet;
import org.jenkinsci.plugins.workflow.cps.CpsBodyInvoker;
import org.jenkinsci.plugins.workflow.cps.CpsBodySubContext;
import org.jenkinsci.plugins.workflow.cps.CpsStepContext;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.CpsVmThreadOnly;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

class CpsBodyExecution
extends BodyExecution {
    @GuardedBy(value="this")
    private CpsThread thread;
    @GuardedBy(value="this")
    private FlowInterruptedException stopped;
    private final List<BodyExecutionCallback> callbacks;
    private final CpsStepContext context;
    private String startNodeId;
    private final Continuation onSuccess = new SuccessAdapter();
    final Continuation onFailure = new FailureAdapter();
    @GuardedBy(value="this")
    private Outcome outcome;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CpsBodyExecution.class.getName());

    CpsBodyExecution(CpsStepContext context, List<BodyExecutionCallback> callbacks) {
        this.context = context;
        this.callbacks = callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CpsVmThreadOnly
    void launch(CpsBodyInvoker params, CpsThread currentThread, FlowHead head) {
        if (this.isLaunched()) {
            throw new IllegalStateException("Already launched");
        }
        StepStartNode sn = this.addBodyStartFlowNode(head);
        for (Action action : params.startNodeActions) {
            if (action == null) continue;
            sn.addAction(action);
        }
        CpsBodySubContext sc = new CpsBodySubContext(this.context, (FlowNode)sn);
        for (Object c : this.callbacks) {
            c.onStart((StepContext)sc);
        }
        try {
            Object c;
            Object object = params.body.getBody(currentThread).call();
            c = this;
            synchronized (c) {
                this.thread = currentThread;
            }
            this.onSuccess.receive(object);
        }
        catch (CpsCallableInvocation cpsCallableInvocation) {
            CpsThread t = currentThread.group.addThread(this.createContinuable(currentThread, cpsCallableInvocation), head, ContextVariableSet.from(currentThread.getContextVariables(), params.contextOverrides));
            CpsBodyExecution cpsBodyExecution = this;
            synchronized (cpsBodyExecution) {
                t.resume(new Outcome(null, (Throwable)this.stopped));
                assert (this.thread == null);
                this.thread = t;
            }
        }
        catch (Throwable throwable) {
            this.onFailure.receive((Object)throwable);
        }
    }

    private Continuable createContinuable(CpsThread currentThread, CpsCallableInvocation inv) {
        FunctionCallEnv caller = new FunctionCallEnv(null, this.onSuccess, null, null);
        if (currentThread.getExecution().isSandbox()) {
            caller.setInvoker((Invoker)new SandboxInvoker());
        }
        TryBlockEnv env = new TryBlockEnv((Env)caller, null);
        env.addHandler(Throwable.class, this.onFailure);
        return new Continuable(inv.invoke((Env)env, null, this.onSuccess));
    }

    public synchronized Collection<StepExecution> getCurrentExecutions() {
        if (this.thread == null) {
            return Collections.emptyList();
        }
        StepExecution s = this.thread.getStep();
        if (s != null) {
            return Collections.singleton(s);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(CauseOfInterruption ... causes) {
        CpsThread t;
        CpsBodyExecution cpsBodyExecution = this;
        synchronized (cpsBodyExecution) {
            if (this.isDone()) {
                return false;
            }
            this.stopped = new FlowInterruptedException(Result.ABORTED, causes);
            t = this.thread;
        }
        if (t != null) {
            t.getExecution().runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

                public void onSuccess(CpsThreadGroup g) {
                    StepExecution s = t.getStep();
                    if (s == null) {
                        return;
                    }
                    try {
                        s.stop((Throwable)CpsBodyExecution.this.stopped);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Failed to stop " + s, e);
                    }
                }

                public void onFailure(Throwable t2) {
                }
            });
        }
        return true;
    }

    public synchronized boolean isCancelled() {
        return this.stopped != null && this.isDone();
    }

    public synchronized boolean isLaunched() {
        return this.thread != null;
    }

    public synchronized Object get() throws InterruptedException, ExecutionException {
        while (this.outcome == null) {
            ((Object)((Object)this)).wait();
        }
        if (this.outcome.isSuccess()) {
            return this.outcome.getNormal();
        }
        throw new ExecutionException(this.outcome.getAbnormal());
    }

    public synchronized Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long remaining;
        long endTime = System.currentTimeMillis() + unit.toMillis(timeout);
        while (this.outcome == null && (remaining = endTime - System.currentTimeMillis()) > 0L) {
            ((Object)((Object)this)).wait(remaining);
        }
        if (this.outcome == null) {
            throw new TimeoutException();
        }
        if (this.outcome.isSuccess()) {
            return this.outcome.getNormal();
        }
        throw new ExecutionException(this.outcome.getAbnormal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOutcome(Outcome o) {
        CpsBodyExecution cpsBodyExecution = this;
        synchronized (cpsBodyExecution) {
            if (this.outcome != null) {
                throw new IllegalStateException("Outcome is already set");
            }
            this.outcome = o;
            ((Object)((Object)this)).notifyAll();
        }
        this.context.saveState();
    }

    public synchronized boolean isDone() {
        return this.outcome != null;
    }

    @Nonnull
    private StepStartNode addBodyStartFlowNode(FlowHead head) {
        StepStartNode start = new StepStartNode(head.getExecution(), this.context.getStepDescriptor(), head.get());
        this.startNodeId = start.getId();
        start.addAction((Action)new BodyInvocationAction());
        head.setNewHead((FlowNode)start);
        return start;
    }

    @Nonnull
    private StepEndNode addBodyEndFlowNode() {
        try {
            FlowHead head = CpsThread.current().head;
            StepEndNode end = new StepEndNode(head.getExecution(), this.getBodyStartNode(), head.get());
            end.addAction((Action)new BodyInvocationAction());
            head.setNewHead((FlowNode)end);
            return end;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to grow the flow graph", e);
            throw new Error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepStartNode getBodyStartNode() throws IOException {
        CpsThread t;
        if (this.startNodeId == null) {
            throw new IllegalStateException("StepStartNode is not yet created");
        }
        CpsBodyExecution cpsBodyExecution = this;
        synchronized (cpsBodyExecution) {
            t = this.thread;
        }
        return (StepStartNode)t.getExecution().getNode(this.startNodeId);
    }

    private class SuccessAdapter
    implements Continuation {
        private static final long serialVersionUID = 1L;

        private SuccessAdapter() {
        }

        public Next receive(Object o) {
            StepEndNode en = CpsBodyExecution.this.addBodyEndFlowNode();
            CpsBodyExecution.this.setOutcome(new Outcome(o, null));
            CpsBodySubContext sc = new CpsBodySubContext(CpsBodyExecution.this.context, (FlowNode)en);
            for (BodyExecutionCallback c : CpsBodyExecution.this.callbacks) {
                c.onSuccess((StepContext)sc, o);
            }
            return Next.terminate(null);
        }
    }

    private class FailureAdapter
    implements Continuation {
        private static final long serialVersionUID = 1L;

        private FailureAdapter() {
        }

        public Next receive(Object o) {
            if (!CpsBodyExecution.this.isLaunched()) {
                CpsBodyExecution.this.addBodyStartFlowNode(CpsThread.current().head);
            }
            StepEndNode en = CpsBodyExecution.this.addBodyEndFlowNode();
            Throwable t = (Throwable)o;
            en.addAction((Action)new ErrorAction(t));
            CpsBodyExecution.this.setOutcome(new Outcome(null, t));
            CpsBodySubContext sc = new CpsBodySubContext(CpsBodyExecution.this.context, (FlowNode)en);
            for (BodyExecutionCallback c : CpsBodyExecution.this.callbacks) {
                c.onFailure((StepContext)sc, t);
            }
            return Next.terminate(null);
        }
    }
}

