/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.slaves.WorkspaceList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsFlowFactoryAction2;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinitionDescriptor;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.steps.scm.GenericSCMStep;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class CpsScmFlowDefinition
extends FlowDefinition {
    private final SCM scm;
    private final String scriptPath;

    @DataBoundConstructor
    public CpsScmFlowDefinition(SCM scm, String scriptPath) {
        this.scm = scm;
        this.scriptPath = scriptPath;
    }

    public SCM getScm() {
        return this.scm;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CpsFlowExecution create(FlowExecutionOwner owner, TaskListener listener, List<? extends Action> actions) throws Exception {
        String script;
        FilePath dir;
        for (Action action : actions) {
            if (!(action instanceof CpsFlowFactoryAction2)) continue;
            return ((CpsFlowFactoryAction2)action).create(this, owner, actions);
        }
        Queue.Executable executable = owner.getExecutable();
        if (!(executable instanceof Run)) {
            throw new IOException("can only check out SCM into a Run");
        }
        Run build = (Run)executable;
        Jenkins node = Jenkins.getActiveInstance();
        if (build.getParent() instanceof TopLevelItem) {
            FilePath baseWorkspace = node.getWorkspaceFor((TopLevelItem)build.getParent());
            if (baseWorkspace == null) {
                throw new IOException(node.getDisplayName() + " may be offline");
            }
            dir = this.getFilePathWithSuffix(baseWorkspace);
        } else {
            dir = new FilePath(owner.getRootDir());
        }
        Computer computer = node.toComputer();
        if (computer == null) {
            throw new IOException(node.getDisplayName() + " may be offline");
        }
        GenericSCMStep delegate = new GenericSCMStep(this.scm);
        delegate.setPoll(true);
        delegate.setChangelog(true);
        WorkspaceList.Lease lease = computer.getWorkspaceList().acquire(dir);
        try {
            delegate.checkout(build, dir, listener, node.createLauncher(listener));
            FilePath scriptFile = dir.child(this.scriptPath);
            if (!scriptFile.absolutize().getRemote().replace('\\', '/').startsWith(dir.absolutize().getRemote().replace('\\', '/') + '/')) {
                throw new IOException(scriptFile + " is not inside " + dir);
            }
            if (!scriptFile.exists()) {
                throw new AbortException(scriptFile + " not found");
            }
            script = scriptFile.readToString();
        }
        finally {
            lease.release();
        }
        CpsFlowExecution exec = new CpsFlowExecution(script, true, owner);
        exec.flowStartNodeActions.add((Action)new WorkspaceActionImpl(dir, null));
        return exec;
    }

    private FilePath getFilePathWithSuffix(FilePath baseWorkspace) {
        return baseWorkspace.withSuffix(this.getFilePathSuffix() + "script");
    }

    private String getFilePathSuffix() {
        return System.getProperty(WorkspaceList.class.getName(), "@");
    }

    @Extension
    public static class DescriptorImpl
    extends FlowDefinitionDescriptor {
        public String getDisplayName() {
            return "Pipeline script from SCM";
        }

        public Collection<? extends SCMDescriptor<?>> getApplicableDescriptors() {
            StaplerRequest req = Stapler.getCurrentRequest();
            Job job = req != null ? (Job)req.findAncestorObject(Job.class) : null;
            return job != null ? SCM._for((Job)job) : SCM.all();
        }
    }
}

