/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import hudson.model.Computer;
import hudson.remoting.SingleLaneExecutorService;
import hudson.security.ACL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import jenkins.util.InterceptingExecutorService;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;

class CpsVmExecutorService
extends InterceptingExecutorService {
    private CpsThreadGroup cpsThreadGroup;
    static ThreadLocal<CpsThreadGroup> CURRENT = new ThreadLocal();

    public CpsVmExecutorService(CpsThreadGroup cpsThreadGroup) {
        super((ExecutorService)new SingleLaneExecutorService(Computer.threadPoolForRemoting));
        this.cpsThreadGroup = cpsThreadGroup;
    }

    protected Runnable wrap(final Runnable r) {
        return new Runnable(){

            @Override
            public void run() {
                String oldThreadName = CpsVmExecutorService.this.setUp();
                try {
                    r.run();
                }
                finally {
                    CpsVmExecutorService.this.tearDown(oldThreadName);
                }
            }
        };
    }

    protected <V> Callable<V> wrap(final Callable<V> r) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                String oldThreadName = CpsVmExecutorService.this.setUp();
                try {
                    Object v = r.call();
                    return v;
                }
                finally {
                    CpsVmExecutorService.this.tearDown(oldThreadName);
                }
            }
        };
    }

    private String setUp() {
        CpsFlowExecution execution = this.cpsThreadGroup.getExecution();
        ACL.impersonate((Authentication)execution.getAuthentication());
        CURRENT.set(this.cpsThreadGroup);
        this.cpsThreadGroup.busy = true;
        Thread t = Thread.currentThread();
        String oldThreadName = t.getName();
        t.setName("Running " + (Object)((Object)execution));
        return oldThreadName;
    }

    private void tearDown(String oldThreadName) {
        CURRENT.set(null);
        this.cpsThreadGroup.busy = false;
        Thread.currentThread().setName(oldThreadName);
    }
}

