/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import jenkins.model.Jenkins;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.AbstractWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.DSL;
import org.jenkinsci.plugins.workflow.cps.EnvActionImpl;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;

class CpsWhitelist
extends AbstractWhitelist {
    private static final Map<Jenkins, Whitelist> wrappedByJenkins = new WeakHashMap<Jenkins, Whitelist>();

    private CpsWhitelist() {
    }

    public boolean permitsMethod(Method method, Object receiver, Object[] args) {
        String name;
        if (receiver instanceof CpsScript) {
            name = method.getName();
            if (name.equals("invokeMethod")) {
                return true;
            }
            if (name.equals("evaluate")) {
                return true;
            }
            if (name.equals("println") || name.equals("print") || name.equals("printf")) {
                return true;
            }
            if (name.equals("getProperty") && args.length == 1 && args[0] instanceof String) {
                for (GlobalVariable v : GlobalVariable.ALL) {
                    if (!v.getName().equals(args[0])) continue;
                    return true;
                }
            }
        }
        if (receiver instanceof DSL && method.getName().equals("invokeMethod")) {
            return true;
        }
        return receiver instanceof EnvActionImpl && ((name = method.getName()).equals("getProperty") || name.equals("setProperty"));
    }

    public boolean permitsConstructor(Constructor<?> constructor, Object[] args) {
        return constructor.getDeclaringClass() == GStringImpl.class;
    }

    public boolean permitsStaticMethod(Method method, Object[] args) {
        return method.getDeclaringClass() == ScriptBytecodeAdapter.class && method.getName().equals("asType");
    }

    public static synchronized Whitelist get() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return new ProxyWhitelist(new Whitelist[0]);
        }
        Whitelist wrapped = wrappedByJenkins.get(j);
        if (wrapped == null) {
            wrapped = new ProxyWhitelist(new Whitelist[]{new CpsWhitelist(), Whitelist.all()});
            wrappedByJenkins.put(j, wrapped);
        }
        return wrapped;
    }
}

