/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import groovy.lang.GroovyObjectSupport;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.EnvironmentContributor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.RunAction2;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.support.actions.EnvironmentAction;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class EnvActionImpl
extends GroovyObjectSupport
implements EnvironmentAction.IncludingOverrides,
Serializable,
RunAction2 {
    private static final Logger LOGGER = Logger.getLogger(EnvActionImpl.class.getName());
    private static final long serialVersionUID = 1L;
    private final Map<String, String> env = new TreeMap<String, String>();
    private transient EnvVars ownerEnvironment;
    private transient Run<?, ?> owner;

    private EnvActionImpl() {
    }

    public EnvVars getEnvironment() throws IOException, InterruptedException {
        if (this.ownerEnvironment == null) {
            this.ownerEnvironment = this.owner.getEnvironment((TaskListener)new LogTaskListener(LOGGER, Level.INFO));
        }
        EnvVars e = new EnvVars(this.ownerEnvironment);
        e.putAll(this.env);
        return e;
    }

    @Exported(name="environment")
    public Map<String, String> getOverriddenEnvironment() {
        return Collections.unmodifiableMap(this.env);
    }

    public Object getProperty(String propertyName) {
        try {
            CpsThread t = CpsThread.current();
            return EnvironmentExpander.getEffectiveEnvironment((EnvVars)this.getEnvironment(), (EnvVars)t.getContextVariable(EnvVars.class), (EnvironmentExpander)t.getContextVariable(EnvironmentExpander.class)).get((Object)propertyName);
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
            return null;
        }
    }

    public void setProperty(String propertyName, Object newValue) {
        this.env.put(propertyName, String.valueOf(newValue));
        try {
            this.owner.save();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    public void onAttached(Run<?, ?> r) {
        this.owner = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.owner = r;
    }

    @Extension
    public static class Binder
    extends GlobalVariable {
        @Override
        public String getName() {
            return "env";
        }

        @Override
        public Object getValue(CpsScript script) throws Exception {
            Run<?, ?> run = script.$build();
            if (run != null) {
                EnvActionImpl action = (EnvActionImpl)run.getAction(EnvActionImpl.class);
                if (action == null) {
                    action = new EnvActionImpl();
                    run.addAction((Action)action);
                }
                return action;
            }
            throw new IllegalStateException("no associated build");
        }

        @Restricted(value={DoNotUse.class})
        public Collection<EnvironmentContributor> getEnvironmentContributors() {
            return EnvironmentContributor.all();
        }
    }
}

