/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import hudson.Extension;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DescriptorByNameOwner;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.RootAction;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.cps.Messages;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class Snippetizer
implements RootAction,
DescriptorByNameOwner {
    public static final String ACTION_URL = "pipeline-syntax";
    @Restricted(value={NoExternalUse.class})
    public static final String GENERATE_URL = "pipeline-syntax/generateSnippet";

    static String object2Groovy(Object o) throws UnsupportedOperationException {
        Class<?> clazz = o.getClass();
        for (StepDescriptor d : StepDescriptor.all()) {
            if (!d.clazz.equals(clazz)) continue;
            StringBuilder b = new StringBuilder(d.getFunctionName());
            Step step = (Step)o;
            TreeMap args = new TreeMap(d.defineArguments(step));
            boolean first = true;
            boolean singleMap = args.size() == 1 && args.values().iterator().next() instanceof Map;
            for (Map.Entry entry : args.entrySet()) {
                if (first) {
                    first = false;
                    if (d.takesImplicitBlockArgument() || singleMap) {
                        b.append('(');
                    } else {
                        b.append(' ');
                    }
                } else {
                    b.append(", ");
                }
                String key = (String)entry.getKey();
                if (args.size() > 1 || !Snippetizer.isDefaultKey(step, key)) {
                    b.append(key).append(": ");
                }
                Snippetizer.render(b, entry.getValue());
            }
            if (d.takesImplicitBlockArgument()) {
                if (!args.isEmpty()) {
                    b.append(')');
                }
                b.append(" {\n    // some block\n}");
            } else if (singleMap) {
                b.append(')');
            } else if (args.isEmpty()) {
                b.append("()");
            }
            return b.toString();
        }
        throw new UnsupportedOperationException("Unknown step " + clazz);
    }

    private static boolean isDefaultKey(Step step, String key) {
        String[] names = new ClassDescriptor(step.getClass(), new Class[0]).loadConstructorParamNames();
        return names.length == 1 && key.equals(names[0]);
    }

    private static void render(StringBuilder b, Object value) {
        if (value == null) {
            b.append("null");
            return;
        }
        Class<?> valueC = value.getClass();
        if (valueC == String.class || valueC == Character.class) {
            String text = String.valueOf(value);
            if (text.contains("\n")) {
                b.append("'''").append(text.replace("\\", "\\\\").replace("'", "\\'")).append("'''");
            } else {
                b.append('\'').append(text.replace("\\", "\\\\").replace("'", "\\'")).append('\'');
            }
        } else if (valueC == Boolean.class || valueC == Integer.class || valueC == Long.class) {
            b.append(value);
        } else if (value instanceof List) {
            List list = (List)value;
            b.append('[');
            boolean first = true;
            for (Object elt : list) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                Snippetizer.render(b, elt);
            }
            b.append(']');
        } else if (value instanceof Map) {
            Map map = (Map)value;
            b.append('[');
            boolean first = true;
            for (Map.Entry entry : map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                Object key = entry.getKey();
                if (key instanceof String && SourceVersion.isName((String)key)) {
                    b.append(key);
                } else {
                    Snippetizer.render(b, key);
                }
                b.append(": ");
                Snippetizer.render(b, entry.getValue());
            }
            b.append(']');
        } else {
            b.append("<object of type ").append(valueC.getCanonicalName()).append('>');
        }
    }

    public String getUrlName() {
        return ACTION_URL;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public Descriptor getDescriptorByName(String id) {
        return Jenkins.getActiveInstance().getDescriptorByName(id);
    }

    @Restricted(value={DoNotUse.class})
    public Collection<? extends StepDescriptor> getStepDescriptors(boolean advanced) {
        TreeSet<StepDescriptor> t = new TreeSet<StepDescriptor>(new StepDescriptorComparator());
        for (StepDescriptor d : StepDescriptor.all()) {
            if (d.isAdvanced() != advanced) continue;
            t.add(d);
        }
        return t;
    }

    @Restricted(value={DoNotUse.class})
    public Iterable<GlobalVariable> getGlobalVariables() {
        return GlobalVariable.ALL;
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doGenerateSnippet(StaplerRequest req, @QueryParameter String json) throws Exception {
        Describable o;
        JSONObject jsonO = JSONObject.fromObject((Object)json);
        Jenkins j = Jenkins.getActiveInstance();
        Class<?> c = j.getPluginManager().uberClassLoader.loadClass(jsonO.getString("stapler-class"));
        StepDescriptor descriptor = (StepDescriptor)j.getDescriptor(c.asSubclass(Step.class));
        try {
            o = descriptor.newInstance(req, jsonO);
        }
        catch (RuntimeException x) {
            return HttpResponses.plainText((String)Functions.printThrowable((Throwable)x));
        }
        try {
            String groovy = Snippetizer.object2Groovy(o);
            if (descriptor.isAdvanced()) {
                String warning = Messages.Snippetizer_this_step_should_not_normally_be_used_in();
                groovy = "// " + warning + "\n" + groovy;
            }
            return HttpResponses.plainText((String)groovy);
        }
        catch (UnsupportedOperationException x) {
            Logger.getLogger(CpsFlowExecution.class.getName()).log(Level.WARNING, "failed to render " + json, x);
            return HttpResponses.plainText((String)x.getMessage());
        }
    }

    public static class LocalAction
    extends Snippetizer {
        @Override
        public String getDisplayName() {
            return "Pipeline Syntax";
        }

        public String getIconClassName() {
            return "icon-help";
        }
    }

    @Extension
    @Restricted(value={DoNotUse.class})
    public static class PerJobAdder
    extends TransientActionFactory<Job> {
        public Class<Job> type() {
            return Job.class;
        }

        public Collection<? extends Action> createFor(Job target) {
            if (target.getClass().getName().equals("org.jenkinsci.plugins.workflow.job.WorkflowJob") && target.hasPermission(Item.EXTENDED_READ)) {
                return Collections.singleton(new LocalAction());
            }
            return Collections.emptySet();
        }
    }

    private static class StepDescriptorComparator
    implements Comparator<StepDescriptor>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private StepDescriptorComparator() {
        }

        @Override
        public int compare(StepDescriptor o1, StepDescriptor o2) {
            return o1.getFunctionName().compareTo(o2.getFunctionName());
        }
    }
}

