/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.replay;

import com.cloudbees.diff.Diff;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Functions;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.queue.QueueTaskFuture;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.model.TransientActionFactory;
import jenkins.scm.api.SCMRevisionAction;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.replay.Messages;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayCause;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayFlowFactoryAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ReplayAction
implements Action {
    private final Run run;
    private static final Iterable<Class<? extends Action>> COPIED_ACTIONS = ImmutableList.of(ParametersAction.class, SCMRevisionAction.class);
    public static final Permission REPLAY = new Permission(Run.PERMISSIONS, "Replay", Messages._Replay_permission_description(), Item.CONFIGURE, PermissionScope.RUN);

    private ReplayAction(Run run) {
        this.run = run;
    }

    public String getDisplayName() {
        return "Replay";
    }

    public String getIconFileName() {
        return this.isEnabled() ? "redo.png" : null;
    }

    public String getUrlName() {
        return this.isEnabled() ? "replay" : null;
    }

    @CheckForNull
    private CpsFlowExecution getExecution() {
        FlowExecutionOwner owner = ((FlowExecutionOwner.Executable)this.run).asFlowExecutionOwner();
        if (owner == null) {
            return null;
        }
        FlowExecution exec = owner.getOrNull();
        return exec instanceof CpsFlowExecution ? (CpsFlowExecution)exec : null;
    }

    public boolean isEnabled() {
        if (!this.run.hasPermission(REPLAY)) {
            return false;
        }
        CpsFlowExecution exec = this.getExecution();
        if (exec == null) {
            return false;
        }
        if (exec.isSandbox()) {
            return true;
        }
        return Jenkins.getActiveInstance().hasPermission(Jenkins.RUN_SCRIPTS);
    }

    public String getOriginalScript() {
        CpsFlowExecution execution = this.getExecution();
        return execution != null ? execution.getScript() : "???";
    }

    public Map<String, String> getOriginalLoadedScripts() {
        CpsFlowExecution execution = this.getExecution();
        return execution != null ? execution.getLoadedScripts() : Collections.emptyMap();
    }

    public Run getOwner() {
        return this.run;
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public void doRun(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        if (!this.isEnabled()) {
            throw new AccessDeniedException("not allowed to replay");
        }
        JSONObject form = req.getSubmittedForm();
        HashMap<String, String> replacementLoadedScripts = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getOriginalLoadedScripts().entrySet()) {
            replacementLoadedScripts.put(entry.getKey(), form.optString(entry.getKey(), entry.getValue()));
        }
        this.run(form.getString("mainScript"), replacementLoadedScripts);
        rsp.sendRedirect("../..");
    }

    @CheckForNull
    public QueueTaskFuture run(@Nonnull String replacementMainScript, @Nonnull Map<String, String> replacementLoadedScripts) {
        ArrayList<ReplayFlowFactoryAction> actions = new ArrayList<ReplayFlowFactoryAction>();
        CpsFlowExecution execution = this.getExecution();
        if (execution == null) {
            return null;
        }
        actions.add(new ReplayFlowFactoryAction(replacementMainScript, replacementLoadedScripts, execution.isSandbox()));
        actions.add((ReplayFlowFactoryAction)new CauseAction(new Cause[]{new Cause.UserIdCause(), new ReplayCause(this.run)}));
        for (Class<? extends Action> c : COPIED_ACTIONS) {
            actions.addAll(this.run.getActions(c));
        }
        return new ParameterizedJobMixIn(){

            protected Job asJob() {
                return ReplayAction.this.run.getParent();
            }
        }.scheduleBuild2(0, actions.toArray(new Action[actions.size()]));
    }

    public String getDiff() {
        Run<?, ?> earlier;
        ReplayCause cause;
        Run<?, ?> original = this.run;
        while ((cause = (ReplayCause)original.getCause(ReplayCause.class)) != null && (earlier = cause.getOriginal()) != null) {
            original = earlier;
        }
        ReplayAction originalAction = (ReplayAction)original.getAction(ReplayAction.class);
        if (originalAction == null) {
            return "???";
        }
        try {
            StringBuilder diff = new StringBuilder(ReplayAction.diff("Jenkinsfile", originalAction.getOriginalScript(), this.getOriginalScript()));
            Map<String, String> originalLoadedScripts = originalAction.getOriginalLoadedScripts();
            for (Map.Entry<String, String> entry : this.getOriginalLoadedScripts().entrySet()) {
                String script = entry.getKey();
                String originalScript = originalLoadedScripts.get(script);
                if (originalScript == null) continue;
                diff.append(ReplayAction.diff(script, originalScript, entry.getValue()));
            }
            return diff.toString();
        }
        catch (IOException x) {
            return Functions.printThrowable((Throwable)x);
        }
    }

    private static String diff(String script, String oldText, String nueText) throws IOException {
        Diff hunks = Diff.diff((Reader)new StringReader(oldText), (Reader)new StringReader(nueText), (boolean)false);
        return hunks.isEmpty() ? "" : hunks.toUnifiedDiff("old/" + script, "new/" + script, (Reader)new StringReader(oldText), (Reader)new StringReader(nueText), 3);
    }

    public FormValidation doCheckScript() {
        return FormValidation.ok();
    }

    public JSON doCheckScriptCompile(@QueryParameter String value) {
        return ((CpsFlowDefinition.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(CpsFlowDefinition.DescriptorImpl.class)).doCheckScriptCompile(value);
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED, before=InitMilestone.EXTENSIONS_AUGMENTED)
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="getEnabled return value discarded")
    public static void ensurePermissionRegistered() {
        REPLAY.getEnabled();
    }

    @Extension
    public static class Factory
    extends TransientActionFactory<Run> {
        public Class<Run> type() {
            return Run.class;
        }

        public Collection<? extends Action> createFor(Run run) {
            return run instanceof FlowExecutionOwner.Executable && run.getParent() instanceof ParameterizedJobMixIn.ParameterizedJob ? Collections.singleton(new ReplayAction(run)) : Collections.emptySet();
        }
    }
}

