/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.replay;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsFlowFactoryAction2;
import org.jenkinsci.plugins.workflow.cps.steps.LoadStepExecution;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;

class ReplayFlowFactoryAction
extends InvisibleAction
implements CpsFlowFactoryAction2,
Queue.QueueAction {
    private static final Logger LOGGER = Logger.getLogger(ReplayFlowFactoryAction.class.getName());
    private String replacementMainScript;
    private final Map<String, String> replacementLoadedScripts;
    private final transient boolean sandbox;

    ReplayFlowFactoryAction(@Nonnull String replacementMainScript, @Nonnull Map<String, String> replacementLoadedScripts, boolean sandbox) {
        this.replacementMainScript = replacementMainScript;
        this.replacementLoadedScripts = new HashMap<String, String>(replacementLoadedScripts);
        this.sandbox = sandbox;
    }

    @Override
    public CpsFlowExecution create(FlowDefinition def, FlowExecutionOwner owner, List<? extends Action> actions) throws IOException {
        String script = this.replacementMainScript;
        this.replacementMainScript = null;
        return new CpsFlowExecution(script, this.sandbox, owner);
    }

    public boolean shouldSchedule(List<Action> actions) {
        return true;
    }

    @Extension
    public static class ReplacerImpl
    implements LoadStepExecution.Replacer {
        @Override
        public String replace(String text, CpsFlowExecution execution, String clazz, TaskListener listener) {
            try {
                Queue.Executable executable = execution.getOwner().getExecutable();
                if (executable instanceof Run) {
                    ReplayFlowFactoryAction action = (ReplayFlowFactoryAction)((Run)executable).getAction(ReplayFlowFactoryAction.class);
                    if (action != null) {
                        String newText = (String)action.replacementLoadedScripts.remove(clazz);
                        if (newText != null) {
                            listener.getLogger().println("Replacing Groovy text with edited version");
                            return newText;
                        }
                        listener.getLogger().println("Warning: no replacement Groovy text found for " + clazz);
                    } else {
                        LOGGER.log(Level.FINE, "{0} was not a replay", executable);
                    }
                } else {
                    LOGGER.log(Level.FINE, "{0} was not a run at all", executable);
                }
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
            return text;
        }
    }
}

