/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Outcome;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import groovy.lang.Closure;
import hudson.model.Result;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.util.ContextResettingExecutorService;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.jenkinsci.plugins.workflow.cps.BodyReference;
import org.jenkinsci.plugins.workflow.cps.CpsBodyInvoker;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.CpsVmThreadOnly;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.DefaultStepContext;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;

@SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class CpsStepContext
extends DefaultStepContext {
    private static final Logger LOGGER = Logger.getLogger(CpsStepContext.class.getName());
    @GuardedBy(value="this")
    private transient Outcome outcome;
    private transient boolean syncMode = true;
    private final FlowExecutionOwner executionRef;
    private final String id;
    transient FlowNode node;
    final List<Integer> bodyHeads = new ArrayList<Integer>();
    transient List<CpsBodyInvoker> bodyInvokers = Collections.synchronizedList(new ArrayList());
    @CheckForNull
    private BodyReference body;
    private final int threadId;
    private final String stepDescriptorId;
    private volatile transient StepDescriptor stepDescriptor;
    private volatile transient CpsThreadGroup threadGroup;
    private volatile transient boolean loadingThreadGroup;
    private static final ExecutorService isReadyExecutorService = new ContextResettingExecutorService(Executors.newCachedThreadPool((ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), "CpsStepContext.isReady")));
    private static final long serialVersionUID = 1L;

    @CpsVmThreadOnly
    CpsStepContext(StepDescriptor step, CpsThread thread, FlowExecutionOwner executionRef, FlowNode node, @CheckForNull Closure body) {
        this.threadId = thread.id;
        this.executionRef = executionRef;
        this.id = node.getId();
        this.node = node;
        this.body = body != null ? thread.group.export(body) : null;
        this.stepDescriptorId = step.getId();
    }

    @CheckForNull
    public StepDescriptor getStepDescriptor() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return null;
        }
        if (this.stepDescriptor == null) {
            this.stepDescriptor = (StepDescriptor)j.getDescriptor(this.stepDescriptorId);
        }
        return this.stepDescriptor;
    }

    public String getDisplayName() {
        StepDescriptor d = this.getStepDescriptor();
        return d != null ? d.getDisplayName() : this.stepDescriptorId;
    }

    protected CpsFlowExecution getExecution() throws IOException {
        return (CpsFlowExecution)this.executionRef.get();
    }

    @CheckForNull
    CpsThread getThread(CpsThreadGroup g) {
        CpsThread thread = (CpsThread)g.threads.get(this.threadId);
        if (thread == null) {
            LOGGER.log(Level.FINE, "no thread " + this.threadId + " among " + g.threads.keySet(), new IllegalStateException());
        }
        return thread;
    }

    @CheckForNull
    private CpsThread getThreadSynchronously() throws InterruptedException, IOException {
        return this.getThread(this.getThreadGroupSynchronously());
    }

    @Nonnull
    private CpsThreadGroup getThreadGroupSynchronously() throws InterruptedException, IOException {
        if (this.threadGroup == null) {
            ListenableFuture<CpsThreadGroup> pp;
            CpsFlowExecution flowExecution = this.getFlowExecution();
            while ((pp = flowExecution.programPromise) == null) {
                Thread.sleep(100L);
            }
            try {
                this.threadGroup = (CpsThreadGroup)pp.get();
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
        return this.threadGroup;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public boolean isReady() {
        if (this.threadGroup == null) {
            if (!this.loadingThreadGroup) {
                isReadyExecutorService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        CpsStepContext.this.getThreadGroupSynchronously();
                        return null;
                    }
                });
                this.loadingThreadGroup = true;
            }
            return false;
        }
        return true;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public CpsBodyInvoker newBodyInvoker() {
        if (this.body == null) {
            throw new IllegalStateException("There is no body to invoke");
        }
        return this.newBodyInvoker(this.body);
    }

    @Nonnull
    public CpsBodyInvoker newBodyInvoker(@Nonnull BodyReference body) {
        return new CpsBodyInvoker(this, body);
    }

    protected <T> T doGet(Class<T> key) throws IOException, InterruptedException {
        CpsThread t = this.getThreadSynchronously();
        if (t == null) {
            throw new IOException("cannot find current thread");
        }
        T v = t.getContextVariable(key);
        if (v != null) {
            return v;
        }
        if (FlowNode.class.isAssignableFrom(key)) {
            return key.cast(this.getNode());
        }
        if (key == CpsThread.class) {
            return key.cast(t);
        }
        if (key == CpsThreadGroup.class) {
            return key.cast(t.group);
        }
        return null;
    }

    protected FlowNode getNode() throws IOException {
        if (this.node == null) {
            this.node = this.getFlowExecution().getNode(this.id);
            if (this.node == null) {
                throw new IOException("no node found for " + this.id);
            }
        }
        return this.node;
    }

    public synchronized void onFailure(Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        if (this.isCompleted()) {
            LOGGER.log(Level.WARNING, "already completed " + (Object)((Object)this), new IllegalStateException(t));
            return;
        }
        this.outcome = new Outcome(null, t);
        this.scheduleNextRun();
    }

    public synchronized void onSuccess(Object returnValue) {
        if (this.isCompleted()) {
            LOGGER.log(Level.WARNING, "already completed " + (Object)((Object)this), new IllegalStateException());
            return;
        }
        this.outcome = new Outcome(returnValue, null);
        this.scheduleNextRun();
    }

    private void scheduleNextRun() {
        if (this.syncMode) {
            return;
        }
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null || jenkins.isQuietingDown()) {
            // empty if block
        }
        try {
            final FlowNode n = this.getNode();
            final CpsFlowExecution flow = this.getFlowExecution();
            final ArrayList<FlowNode> parents = new ArrayList<FlowNode>();
            for (int head : this.bodyHeads) {
                parents.add(flow.getFlowHead(head).get());
            }
            flow.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

                @CpsVmThreadOnly
                public void onSuccess(CpsThreadGroup g) {
                    g.unexport(CpsStepContext.this.body);
                    CpsStepContext.this.body = null;
                    CpsThread thread = CpsStepContext.this.getThread(g);
                    if (thread != null) {
                        CpsThread nit = thread.getNextInner();
                        if (nit != null) {
                            StepExecution s;
                            nit.addCompletionHandler(new ScheduleNextRun());
                            if (CpsStepContext.this.getOutcome().isFailure() && (s = nit.getStep()) != null) {
                                FlowInterruptedException cause = new FlowInterruptedException(Result.FAILURE, new CauseOfInterruption[0]);
                                cause.initCause(CpsStepContext.this.getOutcome().getAbnormal());
                                try {
                                    s.stop((Throwable)cause);
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Failed to stop the body execution in response to the failure of the parent");
                                }
                            }
                            return;
                        }
                        if (n instanceof StepStartNode) {
                            if (parents.isEmpty()) {
                                parents.add(thread.head.get());
                            }
                            for (int i = 1; i < parents.size(); ++i) {
                                g.getExecution().subsumeHead((FlowNode)parents.get(i));
                            }
                            thread.head.setNewHead((FlowNode)new StepEndNode(flow, (StepStartNode)n, parents));
                        }
                        thread.head.markIfFail(CpsStepContext.this.getOutcome());
                        thread.setStep(null);
                        thread.resume(CpsStepContext.this.getOutcome());
                    }
                }

                public void onFailure(Throwable t) {
                }
            });
        }
        catch (IOException x) {
            LOGGER.log(Level.FINE, null, x);
        }
    }

    public void setResult(Result r) {
        try {
            this.getFlowExecution().setResult(r);
        }
        catch (IOException x) {
            LOGGER.log(Level.FINE, null, x);
        }
    }

    @Nonnull
    private CpsFlowExecution getFlowExecution() throws IOException {
        return (CpsFlowExecution)this.executionRef.get();
    }

    synchronized boolean isCompleted() {
        return this.outcome != null;
    }

    synchronized boolean isSyncMode() {
        return this.syncMode;
    }

    synchronized Object replay() {
        try {
            return this.getOutcome().replay();
        }
        catch (Throwable failure) {
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure instanceof Error) {
                throw (Error)failure;
            }
            throw new InvokerInvocationException(failure);
        }
    }

    synchronized Outcome getOutcome() {
        return this.outcome;
    }

    synchronized boolean switchToAsyncMode() {
        if (!this.syncMode) {
            throw new AssertionError();
        }
        this.syncMode = false;
        return !this.isCompleted();
    }

    public ListenableFuture<Void> saveState() {
        try {
            final SettableFuture f = SettableFuture.create();
            this.getFlowExecution().runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

                public void onSuccess(CpsThreadGroup result) {
                    try {
                        result.saveProgram();
                        f.set(null);
                    }
                    catch (IOException x) {
                        f.setException((Throwable)x);
                    }
                }

                public void onFailure(Throwable t) {
                    f.setException(t);
                }
            });
            return f;
        }
        catch (IOException x) {
            return Futures.immediateFailedFuture((Throwable)x);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CpsStepContext that = (CpsStepContext)((Object)o);
        return this.executionRef.equals((Object)that.executionRef) && this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.executionRef.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return "CpsStepContext[" + this.id + "]:" + this.executionRef;
    }

    @SuppressWarnings(value={"SE_INNER_CLASS"})
    private class ScheduleNextRun
    implements FutureCallback<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ScheduleNextRun() {
        }

        public void onSuccess(Object _) {
            CpsStepContext.this.scheduleNextRun();
        }

        public void onFailure(Throwable _) {
            CpsStepContext.this.scheduleNextRun();
        }
    }
}

