/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import hudson.Extension;
import hudson.model.Action;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import jenkins.model.TransientActionFactory;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThreadDump;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;

public final class CpsThreadDumpAction
implements Action {
    private final CpsFlowExecution execution;

    private CpsThreadDumpAction(CpsFlowExecution execution) {
        this.execution = execution;
    }

    public String getIconFileName() {
        return "gear.png";
    }

    public String getDisplayName() {
        return "Thread Dump";
    }

    public String getUrlName() {
        return "threadDump";
    }

    public String getParentUrl() throws IOException {
        return this.execution.getOwner().getUrl();
    }

    CpsThreadDump threadDumpSynchronous() throws InterruptedException, ExecutionException {
        this.execution.waitForSuspension();
        return this.execution.getThreadDump();
    }

    public String getThreadDump() {
        return this.execution.getThreadDump().toString();
    }

    @Extension
    public static class Factory
    extends TransientActionFactory<FlowExecutionOwner.Executable> {
        public Class<FlowExecutionOwner.Executable> type() {
            return FlowExecutionOwner.Executable.class;
        }

        public Collection<? extends Action> createFor(FlowExecutionOwner.Executable executable) {
            FlowExecution exec;
            FlowExecutionOwner owner = executable.asFlowExecutionOwner();
            if (owner != null && (exec = owner.getOrNull()) instanceof CpsFlowExecution && !exec.isComplete()) {
                return Collections.singleton(new CpsThreadDumpAction((CpsFlowExecution)exec));
            }
            return Collections.emptySet();
        }
    }
}

