/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Outcome;
import com.google.common.util.concurrent.Futures;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import groovy.lang.Closure;
import groovy.lang.Script;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Result;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.cps.BodyReference;
import org.jenkinsci.plugins.workflow.cps.ContextVariableSet;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadDump;
import org.jenkinsci.plugins.workflow.cps.CpsVmExecutorService;
import org.jenkinsci.plugins.workflow.cps.CpsVmThreadOnly;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.cps.StaticBodyReference;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.RiverWriter;

@SuppressWarnings(value={"SE_BAD_FIELD"})
public final class CpsThreadGroup
implements Serializable {
    private transient CpsFlowExecution execution;
    final NavigableMap<Integer, CpsThread> threads = new TreeMap<Integer, CpsThread>();
    private int iota;
    transient ExecutorService runner;
    transient boolean busy;
    public final Map<Integer, Closure> closures = new HashMap<Integer, Closure>();
    private transient List<FlowNode> nodesToNotify;
    private static final Object nodesToNotifyLock = new Object();
    private static final Logger LOGGER = Logger.getLogger(CpsThreadGroup.class.getName());
    private static final long serialVersionUID = 1L;

    CpsThreadGroup(CpsFlowExecution execution) {
        this.execution = execution;
        this.setupTransients();
    }

    public CpsFlowExecution getExecution() {
        return this.execution;
    }

    private Object readResolve() {
        this.execution = CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.get();
        this.setupTransients();
        assert (this.execution != null);
        return this;
    }

    private void setupTransients() {
        this.runner = new CpsVmExecutorService(this);
    }

    @CpsVmThreadOnly
    public CpsThread addThread(Continuable program, FlowHead head, ContextVariableSet contextVariables) {
        this.assertVmThread();
        CpsThread t = new CpsThread(this, this.iota++, program, head, contextVariables);
        this.threads.put(t.id, t);
        return t;
    }

    private void assertVmThread() {
        assert (CpsThreadGroup.current() == this);
    }

    public CpsThread getThread(int id) {
        return (CpsThread)this.threads.get(id);
    }

    @Nonnull
    @CpsVmThreadOnly(value="root")
    public BodyReference export(@Nonnull Closure body) {
        this.assertVmThread();
        int id = this.iota++;
        this.closures.put(id, body);
        return new StaticBodyReference(id, body);
    }

    @Nonnull
    @CpsVmThreadOnly(value="root")
    public BodyReference export(final @Nonnull Script body) {
        return this.export(new Closure(null){

            public Object call() {
                return body.run();
            }
        });
    }

    @CpsVmThreadOnly(value="root")
    public void unexport(BodyReference ref) {
        this.assertVmThread();
        if (ref == null) {
            return;
        }
        this.closures.remove(ref.id);
    }

    public Future<?> scheduleRun() {
        Future f;
        try {
            f = this.runner.submit(new Callable<Future<?>>(){

                @Override
                public Future<?> call() throws Exception {
                    CpsThreadGroup.this.run();
                    try {
                        return CpsThreadGroup.this.runner.submit(new Runnable(){

                            @Override
                            public void run() {
                                if (CpsThreadGroup.this.threads.isEmpty()) {
                                    CpsThreadGroup.this.runner.shutdown();
                                }
                            }
                        });
                    }
                    catch (RejectedExecutionException x) {
                        return Futures.immediateFuture(null);
                    }
                }
            });
        }
        catch (RejectedExecutionException x) {
            return Futures.immediateFuture(null);
        }
        return new Future<Object>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (!f.isDone()) {
                    return f.cancel(mayInterruptIfRunning);
                }
                try {
                    return ((Future)f.get()).cancel(mayInterruptIfRunning);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                catch (ExecutionException e) {
                    return false;
                }
            }

            @Override
            public boolean isCancelled() {
                if (f.isCancelled()) {
                    return true;
                }
                if (!f.isDone()) {
                    return false;
                }
                try {
                    return ((Future)f.get()).isCancelled();
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                catch (ExecutionException e) {
                    return false;
                }
            }

            @Override
            public boolean isDone() {
                if (!f.isDone()) {
                    return false;
                }
                try {
                    return ((Future)f.get()).isDone();
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                catch (ExecutionException e) {
                    return false;
                }
            }

            @Override
            public Object get() throws InterruptedException, ExecutionException {
                return ((Future)f.get()).get();
            }

            @Override
            public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return ((Future)f.get(timeout, unit)).get(timeout, unit);
            }
        };
    }

    @CpsVmThreadOnly(value="root")
    private void run() throws IOException {
        boolean changed;
        boolean doneSomeWork = false;
        do {
            changed = false;
            for (CpsThread t : this.threads.values().toArray(new CpsThread[this.threads.size()])) {
                if (!t.isRunnable()) continue;
                Outcome o = t.runNextChunk();
                if (o.isFailure()) {
                    assert (!t.isAlive());
                    Result result = Result.FAILURE;
                    Throwable error = o.getAbnormal();
                    if (error instanceof FlowInterruptedException) {
                        result = ((FlowInterruptedException)error).getResult();
                    }
                    this.execution.setResult(result);
                    t.head.get().addAction((Action)new ErrorAction(error));
                }
                if (!t.isAlive()) {
                    LOGGER.fine("completed " + t);
                    t.fireCompletionHandlers(o);
                    this.threads.remove(t.id);
                    if (this.threads.isEmpty()) {
                        this.execution.onProgramEnd(o);
                    }
                }
                changed = true;
            }
            doneSomeWork |= changed;
        } while (changed);
        if (doneSomeWork) {
            this.saveProgram();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CpsVmThreadOnly
    void notifyNewHead(FlowNode head) {
        this.assertVmThread();
        this.execution.notifyListeners(Collections.singletonList(head), true);
        Object object = nodesToNotifyLock;
        synchronized (object) {
            if (this.nodesToNotify == null) {
                this.nodesToNotify = new ArrayList<FlowNode>();
            }
            this.nodesToNotify.add(head);
        }
        this.runner.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List _nodesToNotify;
                Object object = nodesToNotifyLock;
                synchronized (object) {
                    if (CpsThreadGroup.this.nodesToNotify == null) {
                        return;
                    }
                    _nodesToNotify = CpsThreadGroup.this.nodesToNotify;
                    CpsThreadGroup.this.nodesToNotify = null;
                }
                CpsThreadGroup.this.execution.notifyListeners(_nodesToNotify, false);
            }
        });
    }

    public CpsThreadDump getThreadDump() {
        return CpsThreadDump.from(this);
    }

    @CpsVmThreadOnly
    void saveProgram() throws IOException {
        File f = this.execution.getProgramDataFile();
        this.saveProgram(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CpsVmThreadOnly
    public void saveProgram(File f) throws IOException {
        File dir = f.getParentFile();
        File tmpFile = File.createTempFile("atomic", null, dir);
        this.assertVmThread();
        CpsFlowExecution old = CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.get();
        CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.set(this.execution);
        try {
            block12: {
                try (RiverWriter w = new RiverWriter(tmpFile, this.execution.getOwner());){
                    w.writeObject((Object)this);
                }
                try {
                    Class.forName("java.nio.file.Files");
                    CpsThreadGroup.rename(tmpFile, f);
                }
                catch (ClassNotFoundException x) {
                    Util.deleteFile((File)f);
                    if (tmpFile.renameTo(f)) break block12;
                    throw new IOException("rename " + tmpFile + " to " + f + " failed");
                }
            }
            LOGGER.log(Level.FINE, "program state saved");
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "program state save failed", e);
            this.propagateErrorToWorkflow(e);
            throw new IOException("Failed to persist " + f, e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "program state save failed", e);
            this.propagateErrorToWorkflow(e);
            throw new IOException("Failed to persist " + f, e);
        }
        finally {
            CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.set(old);
            Util.deleteFile((File)tmpFile);
        }
    }

    @IgnoreJRERequirement
    private static void rename(File from, File to) throws IOException {
        Files.move(from.toPath(), to.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    @CpsVmThreadOnly
    private void propagateErrorToWorkflow(Throwable t) {
        Map.Entry<Integer, CpsThread> lastEntry = this.threads.lastEntry();
        if (lastEntry != null) {
            lastEntry.getValue().resume(new Outcome(null, t));
        } else {
            LOGGER.log(Level.WARNING, "encountered error but could not pass it to the flow", t);
        }
    }

    @CpsVmThreadOnly
    static CpsThreadGroup current() {
        return CpsVmExecutorService.CURRENT.get();
    }
}

