/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Outcome;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObjectSupport;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jenkinsci.plugins.workflow.cps.CpsBodyInvoker;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsStepContext;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsVmThreadOnly;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.cps.ThreadTask;
import org.jenkinsci.plugins.workflow.cps.ThreadTaskResult;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.cps.steps.LoadStep;
import org.jenkinsci.plugins.workflow.cps.steps.ParallelStep;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.MissingContextVariableException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.ClassDescriptor;

public class DSL
extends GroovyObjectSupport
implements Serializable {
    private final FlowExecutionOwner handle;
    private transient CpsFlowExecution exec;
    private transient Map<String, StepDescriptor> functions;
    private static final long serialVersionUID = 1L;

    public DSL(FlowExecutionOwner handle) {
        this.handle = handle;
    }

    protected Object readResolve() throws IOException {
        return this;
    }

    @CpsVmThreadOnly
    public Object invokeMethod(String name, Object args) {
        boolean sync;
        Step s;
        StepNode an;
        boolean hack;
        StepDescriptor d;
        try {
            if (this.exec == null) {
                this.exec = (CpsFlowExecution)this.handle.get();
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        if (this.functions == null) {
            this.functions = new TreeMap<String, StepDescriptor>();
            for (StepDescriptor d2 : StepDescriptor.all()) {
                this.functions.put(d2.getFunctionName(), d2);
            }
        }
        if ((d = this.functions.get(name)) == null) {
            throw new NoSuchMethodError("No such DSL method '" + name + "' found among " + this.functions.keySet());
        }
        NamedArgsAndClosure ps = DSL.parseArgs(d, args);
        CpsThread thread = CpsThread.current();
        boolean bl = hack = d instanceof ParallelStep.DescriptorImpl || d instanceof LoadStep.DescriptorImpl;
        if (ps.body == null && !hack) {
            an = new StepAtomNode(this.exec, d, thread.head.get());
            thread.head.setNewHead((FlowNode)an);
        } else {
            an = new StepStartNode(this.exec, d, thread.head.get());
            thread.head.setNewHead((FlowNode)an);
        }
        CpsStepContext context = new CpsStepContext(d, thread, this.handle, (FlowNode)an, ps.body);
        try {
            d.checkContextAvailability((StepContext)context);
            s = d.newInstance(ps.namedArgs);
            StepExecution e = s.start((StepContext)context);
            thread.setStep(e);
            sync = e.start();
        }
        catch (Exception e) {
            if (e instanceof MissingContextVariableException) {
                this.reportMissingContextVariableException(context, (MissingContextVariableException)e);
            }
            context.onFailure(e);
            s = null;
            sync = true;
        }
        if (sync) {
            assert (context.bodyInvokers.isEmpty()) : "If a step claims synchronous completion, it shouldn't invoke body";
            if (context.getOutcome() == null) {
                context.onFailure((Throwable)((Object)new AssertionError((Object)("Step " + s + " claimed to have ended synchronously, but didn't set the result via StepContext.onSuccess/onFailure"))));
            }
            thread.setStep(null);
            if (an instanceof StepStartNode) {
                thread.head.setNewHead((FlowNode)new StepEndNode(this.exec, (StepStartNode)an, new FlowNode[]{an}));
            }
            thread.head.markIfFail(context.getOutcome());
            return context.replay();
        }
        Continuable.suspend((Object)new ThreadTaskImpl(context));
        throw new AssertionError();
    }

    private void reportMissingContextVariableException(CpsStepContext context, MissingContextVariableException e) {
        TaskListener tl;
        try {
            tl = (TaskListener)context.get(TaskListener.class);
            if (tl == null) {
                return;
            }
        }
        catch (IOException _) {
            return;
        }
        catch (InterruptedException _) {
            return;
        }
        StringBuilder names = new StringBuilder();
        for (StepDescriptor p : e.getProviders()) {
            if (names.length() > 0) {
                names.append(',');
            }
            names.append(p.getFunctionName());
        }
        PrintStream logger = tl.getLogger();
        logger.println(e.getMessage());
        if (names.length() > 0) {
            logger.println("Perhaps you forgot to surround the code with a step that provides this, such as: " + names);
        }
    }

    static NamedArgsAndClosure parseArgs(StepDescriptor d, Object arg) {
        boolean expectsBlock = d.takesImplicitBlockArgument();
        if (arg instanceof Map) {
            return new NamedArgsAndClosure((Map)arg, null);
        }
        if (arg instanceof Closure && expectsBlock) {
            return new NamedArgsAndClosure(Collections.emptyMap(), (Closure)arg);
        }
        if (arg instanceof Object[]) {
            List<Object> a = Arrays.asList((Object[])arg);
            if (a.size() == 0) {
                return new NamedArgsAndClosure(Collections.emptyMap(), null);
            }
            Closure c = null;
            Object last = a.get(a.size() - 1);
            if (last instanceof Closure && expectsBlock) {
                c = (Closure)last;
                a = a.subList(0, a.size() - 1);
            }
            if (a.size() == 1 && a.get(0) instanceof Map && !((Map)a.get(0)).containsKey("$class")) {
                return new NamedArgsAndClosure((Map)a.get(0), c);
            }
            switch (a.size()) {
                case 0: {
                    return new NamedArgsAndClosure(Collections.emptyMap(), c);
                }
                case 1: {
                    return new NamedArgsAndClosure(DSL.singleParam(d, a.get(0)), c);
                }
            }
            throw new IllegalArgumentException("Expected named arguments but got " + a);
        }
        return new NamedArgsAndClosure(DSL.singleParam(d, arg), null);
    }

    private static Map<String, Object> singleParam(StepDescriptor d, Object arg) {
        String[] names = new ClassDescriptor(d.clazz, new Class[0]).loadConstructorParamNames();
        if (names.length == 1) {
            return Collections.singletonMap(names[0], arg);
        }
        throw new IllegalArgumentException("Expected named arguments but got " + arg);
    }

    private static class ThreadTaskImpl
    extends ThreadTask
    implements Serializable {
        private final CpsStepContext context;
        private static final long serialVersionUID = 1L;

        public ThreadTaskImpl(CpsStepContext context) {
            this.context = context;
        }

        @Override
        protected ThreadTaskResult eval(CpsThread cur) {
            this.invokeBody(cur);
            if (!this.context.switchToAsyncMode()) {
                return ThreadTaskResult.resumeWith(this.context.getOutcome());
            }
            return ThreadTaskResult.suspendWith(new Outcome((Object)this.context, null));
        }

        private void invokeBody(CpsThread cur) {
            FlowHead[] heads = new FlowHead[this.context.bodyInvokers.size()];
            for (int i = 0; i < heads.length; ++i) {
                heads[i] = i == 0 ? cur.head : cur.head.fork();
            }
            int idx = 0;
            for (CpsBodyInvoker b : this.context.bodyInvokers) {
                FlowHead h = heads[idx];
                b.launch(cur, h);
                this.context.bodyHeads.add(h.getId());
                ++idx;
            }
            this.context.bodyInvokers.clear();
        }

        private static class HeadCollector
        extends BodyExecutionCallback {
            private final CpsStepContext context;
            private final FlowHead head;

            public HeadCollector(CpsStepContext context, FlowHead head) {
                this.context = context;
                this.head = head;
            }

            private void onEnd() {
            }

            public void onSuccess(StepContext context, Object result) {
                this.onEnd();
            }

            public void onFailure(StepContext context, Throwable t) {
                this.onEnd();
            }
        }
    }

    static class NamedArgsAndClosure {
        final Map<String, Object> namedArgs = new LinkedHashMap<String, Object>();
        final Closure body;

        private NamedArgsAndClosure(Map<?, ?> namedArgs, Closure body) {
            this.body = body;
            for (Map.Entry<?, ?> entry : namedArgs.entrySet()) {
                String k = entry.getKey().toString();
                Object v = entry.getValue();
                if (v instanceof GString) {
                    v = v.toString();
                }
                this.namedArgs.put(k, v);
            }
        }
    }
}

