/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.impl.CpsClosure;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;

class GroovyClassLoaderWhitelist
extends Whitelist {
    private final ClassLoader scriptLoader;
    private final Whitelist delegate;

    GroovyClassLoaderWhitelist(GroovyClassLoader scriptLoader, Whitelist delegate) {
        this.scriptLoader = scriptLoader;
        this.delegate = delegate;
    }

    private boolean permits(Class<?> declaringClass) {
        ClassLoader cl = declaringClass.getClassLoader();
        if (cl instanceof GroovyClassLoader.InnerLoader) {
            return cl.getParent() == this.scriptLoader;
        }
        return cl == this.scriptLoader;
    }

    public boolean permitsMethod(Method method, Object receiver, Object[] args) {
        return this.checkJenkins26481(args, method, method.getParameterTypes()) || this.delegate.permitsMethod(method, receiver, args);
    }

    public boolean permitsConstructor(Constructor<?> constructor, Object[] args) {
        return this.checkJenkins26481(args, constructor, constructor.getParameterTypes()) || this.delegate.permitsConstructor(constructor, args);
    }

    public boolean permitsStaticMethod(Method method, Object[] args) {
        return this.checkJenkins26481(args, method, method.getParameterTypes()) || this.delegate.permitsStaticMethod(method, args);
    }

    public boolean permitsFieldGet(Field field, Object receiver) {
        return this.permits(field.getDeclaringClass()) || this.delegate.permitsFieldGet(field, receiver);
    }

    public boolean permitsFieldSet(Field field, Object receiver, Object value) {
        return this.permits(field.getDeclaringClass()) || this.delegate.permitsFieldSet(field, receiver, value);
    }

    public boolean permitsStaticFieldGet(Field field) {
        return this.permits(field.getDeclaringClass()) || this.delegate.permitsStaticFieldGet(field);
    }

    public boolean permitsStaticFieldSet(Field field, Object value) {
        return this.permits(field.getDeclaringClass()) || this.delegate.permitsStaticFieldSet(field, value);
    }

    private boolean checkJenkins26481(Object[] args, Member method, Class<?>[] parameterTypes) throws UnsupportedOperationException {
        if (this.permits(method.getDeclaringClass())) {
            return true;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof CpsClosure) || parameterTypes.length <= i || parameterTypes[i] != Closure.class) continue;
            throw new UnsupportedOperationException("Calling " + method + " on a CPS-transformed closure is not yet supported (JENKINS-26481); encapsulate in a @NonCPS method, or use Java-style loops");
        }
        return false;
    }
}

