/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import hudson.model.Run;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.AbstractWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.DSL;
import org.jenkinsci.plugins.workflow.cps.EnvActionImpl;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.cps.Safepoint;
import org.kohsuke.groovy.sandbox.impl.Checker;

class CpsWhitelist
extends AbstractWhitelist {
    private static final Logger LOGGER = Logger.getLogger(CpsWhitelist.class.getName());
    private static final Map<Jenkins, Whitelist> wrappedByJenkins = new WeakHashMap<Jenkins, Whitelist>();

    private CpsWhitelist() {
    }

    public boolean permitsMethod(Method method, Object receiver, Object[] args) {
        String name;
        if (receiver instanceof CpsScript) {
            name = method.getName();
            if (name.equals("invokeMethod")) {
                return true;
            }
            if (name.equals("evaluate")) {
                return true;
            }
            if (name.equals("println") || name.equals("print") || name.equals("printf")) {
                return true;
            }
            if (name.equals("getProperty") && args.length == 1 && args[0] instanceof String) {
                String property = (String)args[0];
                CpsScript script = (CpsScript)((Object)receiver);
                Run<?, ?> b = script.$buildNoException();
                if (GlobalVariable.byName(property, b) != null) {
                    return true;
                }
                if (b != null) {
                    try {
                        String value = EnvActionImpl.forRun(b).getProperty(property);
                        if (value != null) {
                            return true;
                        }
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }
            }
        }
        if (receiver instanceof DSL && method.getName().equals("invokeMethod")) {
            return true;
        }
        return receiver instanceof EnvActionImpl && ((name = method.getName()).equals("getProperty") || name.equals("setProperty"));
    }

    public boolean permitsConstructor(Constructor<?> constructor, Object[] args) {
        return constructor.getDeclaringClass() == GStringImpl.class;
    }

    public boolean permitsStaticMethod(Method method, Object[] args) {
        Class<?> c = method.getDeclaringClass();
        String n = method.getName();
        if (c == ScriptBytecodeAdapter.class && n.equals("asType")) {
            Object object = args[0];
            Class type = (Class)args[1];
            try {
                Checker.preCheckedCast((Class)type, (Object)object, (boolean)true, (boolean)true, (boolean)false);
            }
            catch (Error | RuntimeException x) {
                throw x;
            }
            catch (Throwable x) {
                throw new RuntimeException(x);
            }
            return true;
        }
        if (Continuable.categories.contains(c)) {
            String cn = c.getName();
            String driverFrom = "com.cloudbees.groovy.cps.Cps";
            String driverTo = "org.codehaus.groovy.runtime.";
            if (cn.startsWith(driverFrom)) {
                try {
                    Class<?> orig = Class.forName(driverTo + cn.substring(driverFrom.length()));
                    Object[] expectedParameterTypes = method.getParameterTypes();
                    String expectedName = n.startsWith("$") ? n.substring(1).replaceFirst("__.+$", "") : n;
                    for (Method m2 : orig.getMethods()) {
                        if (!m2.getName().equals(expectedName) || !Arrays.equals(m2.getParameterTypes(), expectedParameterTypes)) continue;
                        return Whitelist.all().permitsStaticMethod(m2, args);
                    }
                }
                catch (ClassNotFoundException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
            } else {
                LOGGER.log(Level.WARNING, "Unexpected category name {0}", cn);
            }
        }
        return false;
    }

    static synchronized Whitelist get() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            LOGGER.warning("Jenkins is not running");
            return new ProxyWhitelist(new Whitelist[0]);
        }
        Whitelist wrapped = wrappedByJenkins.get(j);
        if (wrapped == null) {
            block5: {
                wrapped = new ProxyWhitelist(new Whitelist[]{new CpsWhitelist(), Whitelist.all()});
                try {
                    if (!wrapped.permitsStaticMethod(Safepoint.class.getMethod("safepoint", new Class[0]), new Object[0])) {
                        throw new IllegalStateException("Broken whitelists: " + wrapped);
                    }
                }
                catch (NoSuchMethodException x) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)x);
                }
            }
            wrappedByJenkins.put(j, wrapped);
        }
        return wrapped;
    }
}

