/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.replay;

import hudson.console.ModelHyperlinkNote;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.cps.replay.Messages;

public class ReplayCause
extends Cause {
    private final int originalNumber;
    private transient Run<?, ?> run;

    ReplayCause(@Nonnull Run<?, ?> original) {
        this.originalNumber = original.getNumber();
    }

    public void onAddedTo(Run run) {
        super.onAddedTo(run);
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        super.onLoad(run);
        this.run = run;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public int getOriginalNumber() {
        return this.originalNumber;
    }

    @CheckForNull
    public Run<?, ?> getOriginal() {
        return this.run.getParent().getBuildByNumber(this.originalNumber);
    }

    public String getShortDescription() {
        return Messages.ReplayCause_shortDescription(this.originalNumber);
    }

    public void print(TaskListener listener) {
        Run<?, ?> original = this.getOriginal();
        if (original != null) {
            listener.getLogger().println("Replayed " + ModelHyperlinkNote.encodeTo(original));
        } else {
            super.print(listener);
        }
    }
}

