/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.steps;

import com.google.common.util.concurrent.FutureCallback;
import com.google.inject.Inject;
import groovy.lang.Script;
import hudson.FilePath;
import hudson.model.TaskListener;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.jenkinsci.plugins.workflow.cps.CpsCompilationErrorsException;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsStepContext;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayAction;
import org.jenkinsci.plugins.workflow.cps.steps.LoadStep;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class LoadStepExecution
extends AbstractStepExecutionImpl {
    @StepContextParameter
    private transient FilePath cwd;
    @Inject(optional=true)
    private transient LoadStep step;
    @StepContextParameter
    private transient TaskListener listener;
    private static final long serialVersionUID = 1L;

    public boolean start() throws Exception {
        Script script;
        CpsStepContext cps = (CpsStepContext)this.getContext();
        CpsThread t = CpsThread.current();
        CpsFlowExecution execution = t.getExecution();
        String text = this.cwd.child(this.step.getPath()).readToString();
        String clazz = execution.getNextScriptName(this.step.getPath());
        String newText = ReplayAction.replace(execution, clazz);
        if (newText != null) {
            this.listener.getLogger().println("Replacing Groovy text with edited version");
            text = newText;
        }
        try {
            script = execution.getShell().parse(text);
        }
        catch (MultipleCompilationErrorsException e) {
            throw new CpsCompilationErrorsException(e);
        }
        cps.newBodyInvoker(t.getGroup().export(script), true).withDisplayName(this.step.getPath()).withCallback(BodyExecutionCallback.wrap((FutureCallback)cps)).start();
        return false;
    }
}

