/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.steps;

import com.cloudbees.groovy.cps.Outcome;
import groovy.lang.Closure;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.cps.CpsVmThreadOnly;
import org.jenkinsci.plugins.workflow.cps.steps.ParallelStepExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public class ParallelStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(ParallelStep.class.getName());
    private final boolean failFast;
    final transient Map<String, Closure> closures;

    public ParallelStep(Map<String, Closure> closures, boolean failFast) {
        this.closures = closures;
        this.failFast = failFast;
    }

    @CpsVmThreadOnly(value="CPS program calls this, which is run by CpsVmThread")
    public StepExecution start(StepContext context) throws Exception {
        return new ParallelStepExecution(this, context);
    }

    boolean isFailFast() {
        return this.failFast;
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        private static final String FAIL_FAST_FLAG = "failFast";

        public String getFunctionName() {
            return "parallel";
        }

        public Step newInstance(Map<String, Object> arguments) {
            boolean failFast = false;
            LinkedHashMap<String, Closure> closures = new LinkedHashMap<String, Closure>();
            for (Map.Entry<String, Object> e : arguments.entrySet()) {
                if (e.getValue() instanceof Closure) {
                    closures.put(e.getKey(), (Closure)e.getValue());
                    continue;
                }
                if (FAIL_FAST_FLAG.equals(e.getKey()) && e.getValue() instanceof Boolean) {
                    failFast = (Boolean)e.getValue();
                    continue;
                }
                throw new IllegalArgumentException("Expected a closure or failFast but found " + e.getKey() + "=" + e.getValue());
            }
            return new ParallelStep(closures, failFast);
        }

        public Map<String, Object> defineArguments(Step step) throws UnsupportedOperationException {
            ParallelStep ps = (ParallelStep)step;
            TreeMap<String, Closure> retVal = new TreeMap<String, Closure>(ps.closures);
            if (ps.failFast) {
                retVal.put(FAIL_FAST_FLAG, (Closure)Boolean.TRUE);
            }
            return retVal;
        }

        public Set<Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }

        public boolean takesImplicitBlockArgument() {
            return false;
        }

        public String getDisplayName() {
            return "Execute in parallel";
        }
    }

    private static final class FailFastException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private FailFastException() {
        }
    }

    static class ResultHandler
    implements Serializable {
        private final StepContext context;
        private final ParallelStepExecution stepExecution;
        private final boolean failFast;
        private boolean stopSent = false;
        private final LinkedHashSet<Throwable> failures = new LinkedHashSet();
        private final Map<String, Outcome> outcomes = new HashMap<String, Outcome>();
        private static final long serialVersionUID = 1L;

        ResultHandler(StepContext context, ParallelStepExecution parallelStepExecution, boolean failFast) {
            this.context = context;
            this.stepExecution = parallelStepExecution;
            this.failFast = failFast;
        }

        Callback callbackFor(String name) {
            this.outcomes.put(name, null);
            return new Callback(this, name);
        }

        private void stopSent() {
            this.stopSent = true;
        }

        private boolean isStopSent() {
            return this.stopSent;
        }

        static final class ThrowableComparator
        implements Comparator<Throwable>,
        Serializable {
            private final List<Throwable> insertionOrder;

            ThrowableComparator() {
                this.insertionOrder = new ArrayList<Throwable>();
            }

            ThrowableComparator(List<Throwable> insertionOrder) {
                this.insertionOrder = insertionOrder;
            }

            @Override
            public int compare(Throwable t1, Throwable t2) {
                if (!(t1 instanceof FlowInterruptedException) && t2 instanceof FlowInterruptedException) {
                    return -1;
                }
                if (t1 instanceof FlowInterruptedException && !(t2 instanceof FlowInterruptedException)) {
                    return 1;
                }
                if (!(t1 instanceof AbortException) && t2 instanceof AbortException) {
                    return -1;
                }
                if (t1 instanceof AbortException && !(t2 instanceof AbortException)) {
                    return 1;
                }
                if (t1 instanceof FlowInterruptedException && t2 instanceof FlowInterruptedException) {
                    Result r2;
                    FlowInterruptedException fie1 = (FlowInterruptedException)t1;
                    FlowInterruptedException fie2 = (FlowInterruptedException)t2;
                    Result r1 = fie1.getResult();
                    if (r1.isWorseThan(r2 = fie2.getResult())) {
                        return -1;
                    }
                    if (r1.isBetterThan(r2)) {
                        return 1;
                    }
                } else if (this.insertionOrder.contains(t1) && this.insertionOrder.contains(t2)) {
                    int index2;
                    int index1 = this.insertionOrder.indexOf(t1);
                    if (index1 < (index2 = this.insertionOrder.indexOf(t2))) {
                        return -1;
                    }
                    if (index1 > index2) {
                        return 1;
                    }
                }
                return 0;
            }
        }

        private static class Callback
        extends BodyExecutionCallback {
            private final ResultHandler handler;
            private final String name;
            private static final long serialVersionUID = 1L;

            Callback(ResultHandler handler, String name) {
                this.handler = handler;
                this.name = name;
            }

            public void onSuccess(StepContext context, Object result) {
                this.handler.outcomes.put(this.name, new Outcome(result, null));
                this.checkAllDone(false);
            }

            public void onFailure(StepContext context, Throwable t) {
                this.handler.outcomes.put(this.name, new Outcome(null, t));
                try {
                    ((TaskListener)context.get(TaskListener.class)).getLogger().println("Failed in branch " + this.name);
                }
                catch (IOException | InterruptedException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
                this.handler.failures.add(t);
                this.checkAllDone(true);
            }

            private void checkAllDone(boolean stepFailed) {
                HashMap success = new HashMap();
                for (Map.Entry e : this.handler.outcomes.entrySet()) {
                    Outcome o = (Outcome)e.getValue();
                    if (o == null) {
                        if (stepFailed && this.handler.failFast && !this.handler.isStopSent()) {
                            this.handler.stopSent();
                            try {
                                this.handler.stepExecution.stop(new FailFastException());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                    if (o.isFailure()) {
                        if (!this.handler.failures.isEmpty()) continue;
                        this.handler.failures.add(((Outcome)e.getValue()).getAbnormal());
                        continue;
                    }
                    success.put(e.getKey(), o.getNormal());
                }
                ArrayList toAttach = new ArrayList(this.handler.failures);
                if (!this.handler.failFast) {
                    Collections.sort(toAttach, new ThrowableComparator(new ArrayList<Throwable>(this.handler.failures)));
                }
                if (!toAttach.isEmpty()) {
                    Throwable head = (Throwable)toAttach.get(0);
                    for (int i = 1; i < toAttach.size(); ++i) {
                        head.addSuppressed((Throwable)toAttach.get(i));
                    }
                    this.handler.context.onFailure(head);
                } else {
                    this.handler.context.onSuccess(success);
                }
            }
        }
    }
}

