/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.RootAction;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public interface GroovySample
extends ExtensionPoint {
    public String name();

    public String title();

    public String script();

    @Restricted(value={DoNotUse.class})
    @Extension(ordinal=100.0)
    public static final class Scripted
    extends Static {
        @Override
        public String name() {
            return "scripted";
        }

        @Override
        public String title() {
            return "Scripted Pipeline";
        }
    }

    @Restricted(value={DoNotUse.class})
    @Extension(ordinal=200.0)
    public static final class GitHubMaven
    extends Static {
        @Override
        public String name() {
            return "github-maven";
        }

        @Override
        public String title() {
            return "GitHub + Maven";
        }
    }

    @Restricted(value={DoNotUse.class})
    @Extension(ordinal=300.0)
    public static final class Hello
    extends Static {
        @Override
        public String name() {
            return "hello";
        }

        @Override
        public String title() {
            return "Hello World";
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static abstract class Static
    implements GroovySample {
        @Override
        public String script() {
            try {
                return IOUtils.toString((URL)GroovySample.class.getResource("samples/" + this.name() + ".groovy"));
            }
            catch (IOException x) {
                throw new AssertionError((Object)x);
            }
        }
    }

    @Restricted(value={DoNotUse.class})
    @Extension
    public static final class Registry
    implements RootAction {
        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return "workflow-cps-samples";
        }

        public JSONObject doIndex() {
            JSONArray samples = new JSONArray();
            ExtensionList.lookup(GroovySample.class).forEach(gs -> samples.add((Object)new JSONObject().accumulate("name", (Object)gs.name()).accumulate("title", (Object)gs.title()).accumulate("script", (Object)gs.script())));
            return new JSONObject().accumulate("samples", (Object)samples);
        }
    }
}

