/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public final class CpsFlowDefinitionValidator {
    private static final String SUCCESS_KEY = "success";
    private static final String FAIL_KEY = "fail";

    private CpsFlowDefinitionValidator() {
    }

    public static List<CheckStatus> toCheckStatus(CompilationFailedException x) {
        ArrayList<CheckStatus> errors = new ArrayList<CheckStatus>();
        if (x instanceof MultipleCompilationErrorsException) {
            for (Object o : ((MultipleCompilationErrorsException)((Object)x)).getErrorCollector().getErrors()) {
                if (!(o instanceof SyntaxErrorMessage)) continue;
                SyntaxException cause = ((SyntaxErrorMessage)o).getCause();
                CheckStatus st = new CheckStatus(cause.getOriginalMessage(), FAIL_KEY);
                st.setLine(cause.getLine());
                st.setColumn(cause.getStartColumn());
                errors.add(st);
            }
        }
        if (errors.isEmpty()) {
            CheckStatus st = new CheckStatus(x.getMessage(), FAIL_KEY);
            st.setLine(1);
            st.setColumn(0);
            errors.add(st);
        }
        return errors;
    }

    public static final class CheckStatus {
        public static final CheckStatus SUCCESS = new CheckStatus("", "success");
        private String message;
        private String status;
        private int line;
        private int column;

        public CheckStatus(String message, String status) {
            this.message = message;
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public JSONObject asJSON() {
            return JSONObject.fromObject((Object)this);
        }
    }
}

