/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Outcome;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.cps.ContextVariableSet;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.CpsVmThreadOnly;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.cps.SandboxContinuable;
import org.jenkinsci.plugins.workflow.cps.ThreadTask;
import org.jenkinsci.plugins.workflow.cps.ThreadTaskResult;
import org.jenkinsci.plugins.workflow.cps.persistence.IteratorHack;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;
import org.jenkinsci.plugins.workflow.support.concurrent.Timeout;

public final class CpsThread
implements Serializable {
    @NonNull
    final CpsThreadGroup group;
    public final int id;
    private volatile Continuable program;
    Outcome resumeValue;
    private transient CompletableFuture<Object> promise;
    final FlowHead head;
    @Nullable
    private ContextVariableSet contextVariables;
    private StepExecution step;
    private final List<FutureCallback<Object>> completionHandlers = new ArrayList<FutureCallback<Object>>();
    private static final List<Class> CATEGORIES = ImmutableList.builder().addAll((Iterable)Continuable.categories).add(IteratorHack.class).build();
    private static final Logger LOGGER = Logger.getLogger(CpsThread.class.getName());
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<CpsThread> CURRENT = new ThreadLocal();

    CpsThread(CpsThreadGroup group, int id, @NonNull Continuable program, FlowHead head, ContextVariableSet contextVariables) {
        this.group = group;
        this.id = id;
        this.program = group.getExecution().isSandbox() ? new SandboxContinuable(program, this) : program;
        this.head = head;
        this.contextVariables = contextVariables;
    }

    public CpsThreadGroup getGroup() {
        return this.group;
    }

    public CpsFlowExecution getExecution() {
        return this.group.getExecution();
    }

    <T> T getContextVariable(Class<T> key, ContextVariableSet.ThrowingSupplier<FlowExecution> execution, ContextVariableSet.ThrowingSupplier<FlowNode> node) throws IOException, InterruptedException {
        T v;
        LOGGER.fine(() -> "looking up " + key.getName() + " from " + this.contextVariables);
        T t = v = this.contextVariables != null ? (T)this.contextVariables.get(key, execution, node) : null;
        if (v != null) {
            return v;
        }
        if (key == CpsThread.class) {
            return key.cast(this);
        }
        if (key == CpsThreadGroup.class) {
            return key.cast(this.group);
        }
        return null;
    }

    public ContextVariableSet getContextVariables() {
        return this.contextVariables;
    }

    boolean isRunnable() {
        return this.resumeValue != null;
    }

    public StepExecution getStep() {
        return this.step;
    }

    void setStep(StepExecution step) {
        this.step = step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    Outcome runNextChunk() {
        Outcome outcome;
        assert (this.program != null);
        CpsThread old = CURRENT.get();
        CURRENT.set(this);
        try (Timeout timeout = Timeout.limit((long)5L, (TimeUnit)TimeUnit.MINUTES);){
            LOGGER.fine(() -> "runNextChunk on " + this.resumeValue);
            Outcome o = this.resumeValue;
            this.resumeValue = null;
            outcome = this.program.run0(o, CATEGORIES);
            if (outcome.getAbnormal() != null) {
                LOGGER.log(Level.FINE, "ran and produced error", outcome.getAbnormal());
            } else {
                Outcome _outcome = outcome;
                LOGGER.fine(() -> "ran and produced " + _outcome);
            }
            if (outcome.getNormal() instanceof ThreadTask) {
                ThreadTask sc = (ThreadTask)outcome.getNormal();
                ThreadTaskResult r = sc.eval(this);
                if (r.resume != null) {
                    this.resumeValue = r.resume;
                } else {
                    outcome = r.suspend;
                }
            }
        }
        finally {
            CURRENT.set(old);
        }
        if (this.promise != null) {
            block21: {
                if (outcome.isSuccess()) {
                    this.promise.complete(outcome.getNormal());
                } else {
                    try {
                        this.promise.completeExceptionally(outcome.getAbnormal());
                    }
                    catch (Error e) {
                        if (e == outcome.getAbnormal()) break block21;
                        throw e;
                    }
                }
            }
            this.promise = null;
        }
        return outcome;
    }

    boolean isAlive() {
        assert (this.program != null);
        return this.program.isResumable();
    }

    void cleanUp() {
        this.program = null;
        this.resumeValue = null;
        this.step = null;
        this.contextVariables = null;
        this.completionHandlers.clear();
    }

    @CpsVmThreadOnly
    void addCompletionHandler(FutureCallback<Object> h) {
        if (!(h instanceof Serializable)) {
            throw new IllegalArgumentException(h.getClass() + " is not serializable");
        }
        this.completionHandlers.add(h);
    }

    @CpsVmThreadOnly
    void fireCompletionHandlers(Outcome o) {
        for (FutureCallback<Object> h : this.completionHandlers) {
            if (o.isSuccess()) {
                h.onSuccess(o.getNormal());
                continue;
            }
            h.onFailure(o.getAbnormal());
        }
    }

    @CheckForNull
    CpsThread getNextInner() {
        for (CpsThread t : this.group.getThreads()) {
            if (t.id <= this.id || t.head != this.head) continue;
            return t;
        }
        return null;
    }

    public Future<Object> resume(Outcome v) {
        if (this.resumeValue != null) {
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("Already resumed with " + this.resumeValue));
        }
        this.resumeValue = v;
        this.promise = new CompletableFuture();
        this.group.scheduleRun();
        return this.promise;
    }

    @CpsVmThreadOnly
    public void stop(Throwable t) {
        StepExecution s = this.getStep();
        if (s == null) {
            Outcome o = new Outcome(null, t);
            if (this.resumeValue == null) {
                this.resume(o);
            } else {
                this.resumeValue = o;
            }
            return;
        }
        try (Timeout timeout = Timeout.limit((long)30L, (TimeUnit)TimeUnit.SECONDS);){
            s.stop(t);
        }
        catch (Exception e) {
            t.addSuppressed(e);
            s.getContext().onFailure(t);
        }
    }

    public List<StackTraceElement> getStackTrace() {
        assert (this.program != null);
        return this.program.getStackTrace();
    }

    @CpsVmThreadOnly
    public static CpsThread current() {
        return CURRENT.get();
    }

    public String toString() {
        return "Thread #" + this.id + String.format(" @%h", this);
    }
}

