/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Main;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.SystemProperties;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;

public abstract class GroovySourceFileAllowlist
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(GroovySourceFileAllowlist.class.getName());
    private static final String DISABLED_PROPERTY = GroovySourceFileAllowlist.class.getName() + ".DISABLED";
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Non-final for script console access")
    static boolean DISABLED = SystemProperties.getBoolean((String)DISABLED_PROPERTY);

    public abstract boolean isAllowed(String var1);

    public static List<GroovySourceFileAllowlist> all() {
        return ExtensionList.lookup(GroovySourceFileAllowlist.class);
    }

    @Extension
    public static class DefaultAllowlist
    extends GroovySourceFileAllowlist {
        private static final Logger LOGGER = Logger.getLogger(DefaultAllowlist.class.getName());
        private static final String ALLOWED_SOURCE_FILES_PROPERTY = DefaultAllowlist.class.getCanonicalName() + ".ALLOWED_SOURCE_FILES";
        static final List<String> ALLOWED_SOURCE_FILES = new ArrayList<String>();

        public DefaultAllowlist() throws IOException {
            String propertyValue = SystemProperties.getString((String)ALLOWED_SOURCE_FILES_PROPERTY, (String)"");
            for (String groovyFile : propertyValue.split(",")) {
                if ((groovyFile = StringUtils.trimToNull((String)groovyFile)) == null) continue;
                if (groovyFile.endsWith(".groovy")) {
                    ALLOWED_SOURCE_FILES.add(groovyFile);
                    LOGGER.log(Level.INFO, "Allowing Pipelines to access {0}", groovyFile);
                    continue;
                }
                LOGGER.log(Level.WARNING, "Ignoring invalid Groovy source file: {0}", groovyFile);
            }
            DefaultAllowlist.loadDefaultAllowlist(ALLOWED_SOURCE_FILES);
            if (Main.isUnitTest) {
                ALLOWED_SOURCE_FILES.addAll(List.of("/org/jenkinsci/plugins/pipeline/modeldefinition/agent/impl/LabelAndOtherFieldAgentScript.groovy", "/org/jenkinsci/plugins/pipeline/modeldefinition/parser/GlobalStageNameTestConditionalScript.groovy", "/org/jenkinsci/plugins/pipeline/modeldefinition/parser/GlobalStepCountTestConditionalScript.groovy"));
            }
        }

        private static void loadDefaultAllowlist(List<String> allowlist) throws IOException {
            try (InputStream is = GroovySourceFileAllowlist.class.getResourceAsStream("GroovySourceFileAllowlist/default-allowlist");
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    allowlist.add(line);
                }
            }
        }

        @Override
        public boolean isAllowed(String groovySourceFileUrl) {
            for (String sourceFile : ALLOWED_SOURCE_FILES) {
                if (!groovySourceFileUrl.endsWith(sourceFile)) continue;
                return true;
            }
            return false;
        }
    }

    static class ClassLoaderImpl
    extends ClassLoader {
        private static final String LOG_MESSAGE_TEMPLATE = "Preventing {0} from being loaded without sandbox protection in {1}. To allow access to this file, add any suffix of its URL to the system property \u2018" + DefaultAllowlist.ALLOWED_SOURCE_FILES_PROPERTY + "\u2019 (use commas to separate multiple files). If you want to allow any Groovy file on the Jenkins classpath to be accessed, you may set the system property \u2018" + DISABLED_PROPERTY + "\u2019 to true.";
        private final String owner;

        public ClassLoaderImpl(@CheckForNull CpsFlowExecution execution, ClassLoader parent) {
            super(parent);
            this.owner = ClassLoaderImpl.describeOwner(execution);
        }

        private static String describeOwner(@CheckForNull CpsFlowExecution execution) {
            if (execution != null) {
                try {
                    return execution.getOwner().getExecutable().toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return "unknown";
        }

        @Override
        public URL getResource(String name) {
            URL url = super.getResource(name);
            if (DISABLED || url == null || !ClassLoaderImpl.endsWithIgnoreCase(name, ".groovy") || ClassLoaderImpl.isAllowed(url)) {
                return url;
            }
            LOGGER.log(Level.WARNING, LOG_MESSAGE_TEMPLATE, new Object[]{url, this.owner});
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration<URL> urls = super.getResources(name);
            if (DISABLED || !urls.hasMoreElements() || !ClassLoaderImpl.endsWithIgnoreCase(name, ".groovy")) {
                return urls;
            }
            ArrayList<URL> filteredUrls = new ArrayList<URL>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (ClassLoaderImpl.isAllowed(url)) {
                    filteredUrls.add(url);
                    continue;
                }
                LOGGER.log(Level.WARNING, LOG_MESSAGE_TEMPLATE, new Object[]{url, this.owner});
            }
            return Collections.enumeration(filteredUrls);
        }

        private static boolean isAllowed(URL url) {
            String urlString = url.toString();
            for (GroovySourceFileAllowlist allowlist : GroovySourceFileAllowlist.all()) {
                if (!allowlist.isAllowed(urlString)) continue;
                return true;
            }
            return false;
        }

        private static boolean endsWithIgnoreCase(String value, String suffix) {
            int suffixLength = suffix.length();
            return value.regionMatches(true, value.length() - suffixLength, suffix, 0, suffixLength);
        }
    }
}

