/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.pickles;

import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.model.Action;
import hudson.model.Executor;
import hudson.model.OneOffExecutor;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.SubTask;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.support.pickles.SingleTypedPickleFactory;
import org.jenkinsci.plugins.workflow.support.pickles.TryRepeatedly;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepExecution;

@Deprecated
public class ExecutorPickle
extends Pickle {
    private static final Logger LOGGER = Logger.getLogger(ExecutorPickle.class.getName());
    private final Queue.Task task;

    private ExecutorPickle(Executor executor) {
        if (executor instanceof OneOffExecutor) {
            throw new IllegalArgumentException("OneOffExecutor not currently supported");
        }
        Queue.Executable exec = executor.getCurrentExecutable();
        if (exec == null) {
            throw new IllegalArgumentException("cannot save an Executor that is not running anything");
        }
        SubTask parent = exec.getParent();
        Queue.Task task = this.task = parent instanceof Queue.Task ? (Queue.Task)parent : parent.getOwnerTask();
        if (this.task instanceof Queue.TransientTask) {
            throw new IllegalArgumentException("cannot save a TransientTask");
        }
        LOGGER.log(Level.FINE, "saving {0}", this.task);
    }

    public ListenableFuture<Executor> rehydrate(final FlowExecutionOwner owner) {
        return new TryRepeatedly<Executor>(1, 0){
            long itemID;
            long endTimeNanos;

            protected Executor tryResolve() throws Exception {
                Queue.Item item;
                if (Jenkins.get().getInitLevel() != InitMilestone.COMPLETED) {
                    LOGGER.fine(() -> "not going to schedule " + ExecutorPickle.this.task + " yet because Jenkins has not yet completed startup");
                    return null;
                }
                if (this.itemID == 0L) {
                    item = Queue.getInstance().schedule2(ExecutorPickle.this.task, 0, new Action[0]).getItem();
                    if (item == null) {
                        throw new IllegalStateException("queue refused " + ExecutorPickle.this.task);
                    }
                    this.itemID = item.getId();
                    this.endTimeNanos = System.nanoTime() + ExecutorStepExecution.TIMEOUT_WAITING_FOR_NODE_MILLIS * 1000000L;
                    LOGGER.log(Level.FINE, "{0} scheduled {1}", new Object[]{ExecutorPickle.this, item});
                } else {
                    item = Queue.getInstance().getItem(this.itemID);
                    if (item == null) {
                        throw new IllegalStateException("queue lost item #" + this.itemID);
                    }
                    LOGGER.log(Level.FINE, "found {0}", item);
                }
                Future future = item.getFuture().getStartCondition();
                if (!future.isDone()) {
                    ExecutorStepExecution.PlaceholderTask placeholder;
                    Queue.Task task = item.task;
                    if (task instanceof ExecutorStepExecution.PlaceholderTask && (placeholder = (ExecutorStepExecution.PlaceholderTask)task).hasStarted() && Jenkins.get().getNode(placeholder.getAssignedLabel().getName()) == null && System.nanoTime() > this.endTimeNanos) {
                        Queue.getInstance().cancel(item);
                        owner.getListener().getLogger().printf("Killed %s after waiting for %s because we assume unknown agent %s is never going to appear%n", item.task.getDisplayName(), Util.getTimeSpanString((long)ExecutorStepExecution.TIMEOUT_WAITING_FOR_NODE_MILLIS), placeholder.getAssignedLabel());
                        throw new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[]{new ExecutorStepExecution.RemovedNodeCause()});
                    }
                    LOGGER.log(Level.FINER, "{0} not yet started", new Object[]{item});
                    return null;
                }
                if (future.isCancelled()) {
                    throw new FlowInterruptedException(Result.ABORTED, true, new CauseOfInterruption[]{new ExecutorStepExecution.QueueTaskCancelled()});
                }
                Queue.Executable exec = (Queue.Executable)future.get();
                Executor e = Executor.of((Queue.Executable)exec);
                if (e != null) {
                    LOGGER.log(Level.FINE, "from {0} found {1}", new Object[]{item, e});
                    return e;
                }
                throw new IllegalStateException(exec + " was scheduled but no executor claimed it");
            }

            @NonNull
            protected FlowExecutionOwner getOwner() {
                return owner;
            }

            protected void printWaitingMessage(@NonNull TaskListener listener) {
                Queue.Item item = Queue.getInstance().getItem(this.itemID);
                String message = "Waiting to resume " + ExecutorPickle.this.task.getFullDisplayName();
                if (item == null) {
                    listener.getLogger().println(message);
                    return;
                }
                CauseOfBlockage causeOfBlockage = item.getCauseOfBlockage();
                if (causeOfBlockage != null) {
                    listener.getLogger().print(message + ": ");
                    causeOfBlockage.print(listener);
                } else {
                    listener.getLogger().println(message);
                }
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                Queue.Item item = Queue.getInstance().getItem(this.itemID);
                if (item != null) {
                    if (Queue.getInstance().cancel(item)) {
                        LOGGER.log(Level.FINE, "canceled {0}", item);
                    } else {
                        LOGGER.log(Level.WARNING, "failed to cancel {0}", item);
                    }
                } else {
                    LOGGER.log(Level.FINE, "no such item {0} to cancel", this.itemID);
                }
                return super.cancel(mayInterruptIfRunning);
            }

            public String toString() {
                Queue.Item item = Queue.getInstance().getItem(this.itemID);
                if (item != null) {
                    return "Trying to schedule " + ExecutorPickle.this.task.getFullDisplayName() + "; blockage: " + item.getCauseOfBlockage();
                }
                return "Trying to locate queue item #" + this.itemID;
            }
        };
    }

    @Extension
    public static final class Factory
    extends SingleTypedPickleFactory<Executor> {
        @NonNull
        protected Pickle pickle(@NonNull Executor object) {
            return new ExecutorPickle(object);
        }
    }
}

