/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Set;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.steps.WorkspaceStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public final class WorkspaceStep
extends Step {
    private final String dir;

    @DataBoundConstructor
    public WorkspaceStep(String dir) {
        this.dir = Util.fixEmptyAndTrim((String)dir);
    }

    public String getDir() {
        return this.dir;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new WorkspaceStepExecution(context, this.dir);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "ws";
        }

        @NonNull
        public String getDisplayName() {
            return "Allocate workspace";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Computer.class, Run.class, TaskListener.class, FlowNode.class);
        }
    }
}

