/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.FilePathUtils;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.DynamicContext;
import org.jenkinsci.plugins.workflow.support.steps.AgentOfflineException;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepDynamicContext;

@Extension(ordinal=100.0)
public final class FilePathDynamicContext
extends DynamicContext.Typed<FilePath> {
    private static final Logger LOGGER = Logger.getLogger(FilePathDynamicContext.class.getName());

    @NonNull
    protected Class<FilePath> type() {
        return FilePath.class;
    }

    protected FilePath get(DynamicContext.DelegatedContext context) throws IOException, InterruptedException {
        FilePath f;
        FilePathRepresentation r = (FilePathRepresentation)context.get(FilePathRepresentation.class);
        if (r == null) {
            return null;
        }
        ExecutorStepDynamicContext esdc = (ExecutorStepDynamicContext)context.get(ExecutorStepDynamicContext.class);
        LOGGER.fine(() -> "ESDC=" + esdc + " FPR=" + r);
        if (esdc != null) {
            if (esdc.depth > r.depth) {
                LOGGER.fine(() -> "skipping " + r.path + "@" + r.slave + " since at depth " + r.depth + " it is shallower than " + esdc.node + "@" + esdc.path + " at depth " + esdc.depth);
                return null;
            }
            LOGGER.fine(() -> "not skipping " + r.path + "@" + r.slave + " since at depth " + r.depth + " it is deeper than " + esdc.node + "@" + esdc.path + " at depth " + esdc.depth);
        }
        if ((f = FilePathUtils.find((String)r.slave, (String)r.path)) == null) {
            OfflineCause oc;
            TaskListener listener;
            AgentOfflineException e = new AgentOfflineException("Unable to create live FilePath for " + r.slave);
            Computer c = Jenkins.get().getComputer(r.slave);
            if (c != null) {
                for (Computer.TerminationRequest tr : c.getTerminatedBy()) {
                    e.addSuppressed((Throwable)tr);
                }
            }
            if ((listener = (TaskListener)context.get(TaskListener.class)) != null && (oc = c.getOfflineCause()) != null) {
                listener.getLogger().println(c.getDisplayName() + " was marked offline: " + oc);
            }
            throw e;
        }
        LOGGER.log(Level.FINE, "serving {0}:{1}", new Object[]{r.slave, r.path});
        return f;
    }

    @Deprecated
    public static Object createContextualObject(FilePath f) {
        return new FilePathRepresentation(FilePathUtils.getNodeName((FilePath)f), f.getRemote(), 0);
    }

    public static Object createContextualObject(@NonNull FilePath f, @NonNull FlowNode n) {
        return new FilePathRepresentation(FilePathUtils.getNodeName((FilePath)f), f.getRemote(), FilePathDynamicContext.depthOf(n));
    }

    static int depthOf(@NonNull FlowNode n) {
        return n.getEnclosingBlocks().size();
    }

    static final class FilePathRepresentation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String slave;
        private final String path;
        private final int depth;

        FilePathRepresentation(String slave, String path, int depth) {
            this.slave = slave;
            this.path = path;
            this.depth = depth;
        }

        public String toString() {
            return "FilePathRepresentation[" + this.path + "@" + this.slave + "]";
        }
    }
}

