/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps;

import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.util.Set;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.steps.FilePathDynamicContext;
import org.kohsuke.stapler.DataBoundConstructor;

public class PushdStep
extends Step {
    private final String path;

    @DataBoundConstructor
    public PushdStep(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this.path, context);
    }

    public static class Execution
    extends StepExecution {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient String path;
        private static final long serialVersionUID = 1L;

        Execution(String path, StepContext context) {
            super(context);
            this.path = path;
        }

        public boolean start() throws Exception {
            FilePath dir = ((FilePath)this.getContext().get(FilePath.class)).child(this.path);
            ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("Running in " + dir);
            this.getContext().newBodyInvoker().withContext(FilePathDynamicContext.createContextualObject(dir, (FlowNode)this.getContext().get(FlowNode.class))).withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).start();
            return false;
        }
    }

    @Extension(ordinal=100.0)
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "dir";
        }

        @NonNull
        public String getDisplayName() {
            return "Change current directory";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(TaskListener.class, FilePath.class, FlowNode.class);
        }

        public Set<? extends Class<?>> getProvidedContext() {
            return Set.of(FilePath.class);
        }
    }
}

