/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.slaves.WorkspaceList;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.FilePathUtils;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;
import org.jenkinsci.plugins.workflow.support.steps.FilePathDynamicContext;

public class WorkspaceStepExecution
extends AbstractStepExecutionImpl {
    private static final Logger LOGGER = Logger.getLogger(WorkspaceStepExecution.class.getName());
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="only used from #start")
    private final transient String dir;
    private static final long serialVersionUID = 1L;

    WorkspaceStepExecution(StepContext context, String dir) {
        super(context);
        this.dir = dir;
    }

    public boolean start() throws Exception {
        WorkspaceList.Lease lease;
        Job job = ((Run)this.getContext().get(Run.class)).getParent();
        if (!(job instanceof TopLevelItem)) {
            throw new Exception(job + " must be a top-level job");
        }
        Computer computer = (Computer)this.getContext().get(Computer.class);
        Node node = computer.getNode();
        if (node == null) {
            throw new Exception("computer does not correspond to a live node");
        }
        if (this.dir == null) {
            FilePath baseWorkspace = node.getWorkspaceFor((TopLevelItem)job);
            if (baseWorkspace == null) {
                throw new IllegalStateException(node + " is offline");
            }
            lease = computer.getWorkspaceList().allocate(baseWorkspace);
        } else {
            FilePath rootPath = node.getRootPath();
            if (rootPath == null) {
                throw new IllegalStateException(node + " is offline");
            }
            FilePath baseWorkspace = rootPath.child(this.dir);
            lease = computer.getWorkspaceList().allocate(baseWorkspace);
        }
        FilePath workspace = lease.path;
        FlowNode flowNode = (FlowNode)this.getContext().get(FlowNode.class);
        flowNode.addAction((Action)new WorkspaceActionImpl(workspace, flowNode));
        ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("Running in " + workspace);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("WORKSPACE", workspace.getRemote());
        FilePath tempDir = WorkspaceList.tempDir((FilePath)workspace);
        if (tempDir != null) {
            env.put("WORKSPACE_TMP", tempDir.getRemote());
        }
        this.getContext().newBodyInvoker().withContexts(new Object[]{EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)EnvironmentExpander.constant(env)), FilePathDynamicContext.createContextualObject(workspace, flowNode)}).withCallback((BodyExecutionCallback)new Callback(lease)).start();
        return false;
    }

    private static final class Callback
    extends BodyExecutionCallback.TailCall {
        private transient WorkspaceList.Lease lease;
        private final String node;
        private final String path;
        private static final long serialVersionUID = 525857611466436091L;

        Callback(WorkspaceList.Lease lease) {
            this.lease = lease;
            this.node = FilePathUtils.getNodeName((FilePath)lease.path);
            this.path = lease.path.getRemote();
        }

        protected void finished(StepContext context) throws Exception {
            if (this.lease == null) {
                FilePath fp = FilePathUtils.find((String)this.node, (String)this.path);
                if (fp == null) {
                    LOGGER.fine(() -> "can no longer find " + this.path + " on " + this.node + " to release");
                    return;
                }
                LOGGER.fine(() -> "recreating lease on " + fp);
                Computer c = fp.toComputer();
                if (c == null) {
                    LOGGER.warning(() -> this.node + " no longer connected");
                    return;
                }
                this.lease = c.getWorkspaceList().allocate(fp);
                if (!this.lease.path.equals((Object)fp)) {
                    this.lease.release();
                    LOGGER.warning(() -> "JENKINS-37121: something already locked " + fp + " != " + this.lease.path);
                    return;
                }
            }
            this.lease.release();
        }
    }

    @Deprecated
    private static final class ExpanderImpl
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final String path;

        private ExpanderImpl(String path) {
            this.path = path;
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            env.override("WORKSPACE", this.path);
        }
    }
}

