/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Action;
import hudson.model.BuildAuthorizationToken;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.ResourceList;
import hudson.model.Run;
import hudson.model.RunMap;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.listeners.SCMListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskFuture;
import hudson.model.queue.SubTask;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.search.SearchIndexBuilder;
import hudson.security.ACL;
import hudson.slaves.WorkspaceList;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.DescribableList;
import hudson.widgets.HistoryWidget;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.model.lazy.LazyBuildMixIn;
import jenkins.triggers.SCMTriggerItem;
import jenkins.util.TimeDuration;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinitionDescriptor;
import org.jenkinsci.plugins.workflow.job.Messages;
import org.jenkinsci.plugins.workflow.job.WorkflowJobProperty;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

public final class WorkflowJob
extends Job<WorkflowJob, WorkflowRun>
implements BuildableItem,
LazyBuildMixIn.LazyLoadingJob<WorkflowJob, WorkflowRun>,
ParameterizedJobMixIn.ParameterizedJob,
TopLevelItem,
Queue.FlyweightTask,
SCMTriggerItem {
    private FlowDefinition definition;
    private DescribableList<Trigger<?>, TriggerDescriptor> triggers = new DescribableList((Saveable)this);
    private volatile Integer quietPeriod;
    private BuildAuthorizationToken authToken;
    private transient LazyBuildMixIn<WorkflowJob, WorkflowRun> buildMixIn = this.createBuildMixIn();
    @CheckForNull
    private Boolean concurrentBuild;
    private volatile transient Map<String, SCMRevisionState> pollingBaselines;

    public WorkflowJob(ItemGroup parent, String name) {
        super(parent, name);
    }

    public void onCreatedFromScratch() {
        super.onCreatedFromScratch();
        this.buildMixIn.onCreatedFromScratch();
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        if (this.buildMixIn == null) {
            this.buildMixIn = this.createBuildMixIn();
        }
        this.buildMixIn.onLoad(parent, name);
        if (this.triggers == null) {
            this.triggers = new DescribableList((Saveable)this);
        } else {
            this.triggers.setOwner((Saveable)this);
        }
        for (Trigger t : this.triggers) {
            t.start((Item)this, Items.currentlyUpdatingByXml());
        }
    }

    private LazyBuildMixIn<WorkflowJob, WorkflowRun> createBuildMixIn() {
        return new LazyBuildMixIn<WorkflowJob, WorkflowRun>(){

            protected WorkflowJob asJob() {
                return WorkflowJob.this;
            }

            protected Class<WorkflowRun> getBuildClass() {
                return WorkflowRun.class;
            }
        };
    }

    private ParameterizedJobMixIn<WorkflowJob, WorkflowRun> createParameterizedJobMixIn() {
        return new ParameterizedJobMixIn<WorkflowJob, WorkflowRun>(){

            protected WorkflowJob asJob() {
                return WorkflowJob.this;
            }
        };
    }

    public FlowDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(FlowDefinition definition) {
        this.definition = definition;
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.definition = (FlowDefinition)req.bindJSON(FlowDefinition.class, json.getJSONObject("definition"));
        this.authToken = BuildAuthorizationToken.create((StaplerRequest)req);
        for (Trigger t : this.triggers) {
            t.stop();
        }
        this.quietPeriod = req.getParameter("hasCustomQuietPeriod") != null ? Integer.valueOf(Integer.parseInt(req.getParameter("quiet_period"))) : null;
        this.triggers.rebuild(req, json, Trigger.for_((Item)this));
        for (Trigger t : this.triggers) {
            t.start((Item)this, true);
        }
        this.concurrentBuild = json.optBoolean("concurrentBuild") ? null : Boolean.valueOf(false);
    }

    public boolean isBuildable() {
        return true;
    }

    protected RunMap<WorkflowRun> _getRuns() {
        return this.buildMixIn._getRuns();
    }

    public LazyBuildMixIn<WorkflowJob, WorkflowRun> getLazyBuildMixIn() {
        return this.buildMixIn;
    }

    protected void removeRun(WorkflowRun run) {
        this.buildMixIn.removeRun((Run)run);
    }

    @Deprecated
    public WorkflowRun getBuild(String id) {
        return (WorkflowRun)this.buildMixIn.getBuild(id);
    }

    public WorkflowRun getBuildByNumber(int n) {
        return (WorkflowRun)this.buildMixIn.getBuildByNumber(n);
    }

    public WorkflowRun getFirstBuild() {
        return (WorkflowRun)this.buildMixIn.getFirstBuild();
    }

    public WorkflowRun getLastBuild() {
        return (WorkflowRun)this.buildMixIn.getLastBuild();
    }

    public WorkflowRun getNearestBuild(int n) {
        return (WorkflowRun)this.buildMixIn.getNearestBuild(n);
    }

    public WorkflowRun getNearestOldBuild(int n) {
        return (WorkflowRun)this.buildMixIn.getNearestOldBuild(n);
    }

    protected HistoryWidget createHistoryWidget() {
        return this.buildMixIn.createHistoryWidget();
    }

    public Queue.Executable createExecutable() throws IOException {
        return (Queue.Executable)this.buildMixIn.newBuild();
    }

    @Deprecated
    public boolean scheduleBuild() {
        return this.createParameterizedJobMixIn().scheduleBuild();
    }

    public boolean scheduleBuild(Cause c) {
        return this.createParameterizedJobMixIn().scheduleBuild(c);
    }

    @Deprecated
    public boolean scheduleBuild(int quietPeriod) {
        return this.createParameterizedJobMixIn().scheduleBuild(quietPeriod);
    }

    public boolean scheduleBuild(int quietPeriod, Cause c) {
        return this.createParameterizedJobMixIn().scheduleBuild(quietPeriod, c);
    }

    @CheckForNull
    public QueueTaskFuture<WorkflowRun> scheduleBuild2(int quietPeriod, Action ... actions) {
        return this.createParameterizedJobMixIn().scheduleBuild2(quietPeriod, actions);
    }

    public void doBuild(StaplerRequest req, StaplerResponse rsp, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        this.createParameterizedJobMixIn().doBuild(req, rsp, delay);
    }

    public void doBuildWithParameters(StaplerRequest req, StaplerResponse rsp, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        this.createParameterizedJobMixIn().doBuildWithParameters(req, rsp, delay);
    }

    @RequirePOST
    public void doCancelQueue(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.createParameterizedJobMixIn().doCancelQueue(req, rsp);
    }

    protected SearchIndexBuilder makeSearchIndex() {
        return this.createParameterizedJobMixIn().extendSearchIndex(super.makeSearchIndex());
    }

    public boolean isParameterized() {
        return this.createParameterizedJobMixIn().isParameterized();
    }

    public BuildAuthorizationToken getAuthToken() {
        return this.authToken;
    }

    public int getQuietPeriod() {
        return this.quietPeriod != null ? this.quietPeriod.intValue() : Jenkins.getActiveInstance().getQuietPeriod();
    }

    @Restricted(value={DoNotUse.class})
    public boolean getHasCustomQuietPeriod() {
        return this.quietPeriod != null;
    }

    public void setQuietPeriod(Integer seconds) throws IOException {
        this.quietPeriod = seconds;
        this.save();
    }

    public String getBuildNowText() {
        return this.createParameterizedJobMixIn().getBuildNowText();
    }

    public boolean isBuildBlocked() {
        return this.getCauseOfBlockage() != null;
    }

    @Deprecated
    public String getWhyBlocked() {
        CauseOfBlockage c = this.getCauseOfBlockage();
        return c != null ? c.getShortDescription() : null;
    }

    public CauseOfBlockage getCauseOfBlockage() {
        if (this.isLogUpdated() && !this.isConcurrentBuild()) {
            return new BecauseOfBuildInProgress(this.getLastBuild());
        }
        return null;
    }

    @Exported
    public boolean isConcurrentBuild() {
        return !Boolean.FALSE.equals(this.concurrentBuild);
    }

    public void setConcurrentBuild(boolean b) throws IOException {
        this.concurrentBuild = b ? null : Boolean.valueOf(false);
        this.save();
    }

    public ACL getACL() {
        ACL acl = super.getACL();
        for (JobProperty property : this.properties) {
            if (!(property instanceof WorkflowJobProperty)) continue;
            acl = ((WorkflowJobProperty)property).decorateACL(acl);
        }
        return acl;
    }

    public void checkAbortPermission() {
        this.checkPermission(CANCEL);
    }

    public boolean hasAbortPermission() {
        return this.hasPermission(CANCEL);
    }

    public Collection<? extends SubTask> getSubTasks() {
        ArrayList<WorkflowJob> subTasks = new ArrayList<WorkflowJob>();
        subTasks.add(this);
        for (JobProperty p : this.properties) {
            subTasks.addAll(p.getSubTasks());
        }
        return subTasks;
    }

    public Authentication getDefaultAuthentication() {
        return ACL.SYSTEM;
    }

    public Authentication getDefaultAuthentication(Queue.Item item) {
        return this.getDefaultAuthentication();
    }

    public Label getAssignedLabel() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return null;
        }
        return j.getSelfLabel();
    }

    public Node getLastBuiltOn() {
        return Jenkins.getInstance();
    }

    public Queue.Task getOwnerTask() {
        return this;
    }

    public Object getSameNodeConstraint() {
        return this;
    }

    public ResourceList getResourceList() {
        return ResourceList.EMPTY;
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get((AlternativeUiTextProvider.Message)PRONOUN, (Object)((Object)this), (String)"Pipeline");
    }

    public TopLevelItemDescriptor getDescriptor() {
        return (DescriptorImpl)Jenkins.getActiveInstance().getDescriptorOrDie(WorkflowJob.class);
    }

    public Map<TriggerDescriptor, Trigger<?>> getTriggers() {
        return this.triggers.toMap();
    }

    public void addTrigger(Trigger trigger) {
        Trigger old = (Trigger)this.triggers.get((Descriptor)trigger.getDescriptor());
        if (old != null) {
            old.stop();
            this.triggers.remove((Object)old);
        }
        this.triggers.add((Object)trigger);
        trigger.start((Item)this, true);
    }

    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>(super.getActions());
        for (Trigger trigger : this.triggers) {
            actions.addAll(trigger.getProjectActions());
        }
        return actions;
    }

    public void addAction(Action a) {
        super.getActions().add(a);
    }

    public void replaceAction(Action a) {
        ArrayList<Action> old = new ArrayList<Action>(1);
        List current = super.getActions();
        for (Action a2 : current) {
            if (a2.getClass() != a.getClass()) continue;
            old.add(a2);
        }
        current.removeAll(old);
        this.addAction(a);
    }

    public Item asItem() {
        return this;
    }

    public SCMTrigger getSCMTrigger() {
        return (SCMTrigger)this.triggers.get(SCMTrigger.class);
    }

    public Collection<? extends SCM> getSCMs() {
        WorkflowRun b = (WorkflowRun)this.getLastCompletedBuild();
        if (b == null) {
            return Collections.emptySet();
        }
        LinkedHashMap<String, SCM> scms = new LinkedHashMap<String, SCM>();
        for (WorkflowRun.SCMCheckout co : b.checkouts(null)) {
            scms.put(co.scm.getKey(), co.scm);
        }
        return scms.values();
    }

    @CheckForNull
    public SCM getTypicalSCM() {
        SCM typical = null;
        for (SCM sCM : this.getSCMs()) {
            if (typical == null) {
                typical = sCM;
                continue;
            }
            if (typical.getDescriptor() == sCM.getDescriptor()) continue;
            return null;
        }
        return typical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollingResult poll(TaskListener listener) {
        WorkflowRun lastBuild = this.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("no previous build to compare to");
            return Queue.getInstance().contains((Queue.Task)this) ? PollingResult.NO_CHANGES : PollingResult.BUILD_NOW;
        }
        WorkflowRun perhapsCompleteBuild = (WorkflowRun)this.getLastSuccessfulBuild();
        if (perhapsCompleteBuild == null) {
            perhapsCompleteBuild = lastBuild;
        }
        if (this.pollingBaselines == null) {
            this.pollingBaselines = new ConcurrentHashMap<String, SCMRevisionState>();
        }
        PollingResult result = PollingResult.NO_CHANGES;
        for (WorkflowRun.SCMCheckout co : perhapsCompleteBuild.checkouts(listener)) {
            if (!co.scm.supportsPolling()) {
                listener.getLogger().println("polling not supported from " + co.workspace + " on " + co.node);
                continue;
            }
            String key = co.scm.getKey();
            SCMRevisionState pollingBaseline = this.pollingBaselines.get(key);
            if (pollingBaseline == null) {
                pollingBaseline = co.pollingBaseline;
            }
            if (pollingBaseline == null) {
                listener.getLogger().println("no polling baseline in " + co.workspace + " on " + co.node);
                continue;
            }
            try {
                PollingResult r;
                WorkspaceList.Lease lease;
                Launcher launcher;
                FilePath workspace;
                if (co.scm.requiresWorkspaceForPolling()) {
                    Jenkins j = Jenkins.getInstance();
                    if (j == null) {
                        listener.error("Jenkins is shutting down");
                        continue;
                    }
                    Computer c = j.getComputer(co.node);
                    if (c == null) {
                        listener.error("no such computer " + co.node);
                        continue;
                    }
                    workspace = new FilePath(c.getChannel(), co.workspace);
                    launcher = workspace.createLauncher(listener).decorateByEnv(this.getEnvironment(c.getNode(), listener));
                    lease = c.getWorkspaceList().acquire(workspace, !this.isConcurrentBuild());
                } else {
                    workspace = null;
                    launcher = null;
                    lease = null;
                }
                try {
                    r = co.scm.compareRemoteRevisionWith((Job)this, launcher, workspace, listener, pollingBaseline);
                    if (r.remote != null) {
                        this.pollingBaselines.put(key, r.remote);
                    }
                }
                finally {
                    if (lease != null) {
                        lease.release();
                    }
                }
                if (r.change.compareTo((Enum)result.change) <= 0) continue;
                result = r;
            }
            catch (AbortException x) {
                listener.error("polling failed in " + co.workspace + " on " + co.node + ": " + x.getMessage());
            }
            catch (Exception x) {
                x.printStackTrace(listener.error("polling failed in " + co.workspace + " on " + co.node));
            }
        }
        return result;
    }

    protected void performDelete() throws IOException, InterruptedException {
        super.performDelete();
    }

    @Initializer(before=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void alias() {
        Items.XSTREAM2.alias("flow-definition", WorkflowJob.class);
        WorkflowRun.alias();
    }

    @Extension(ordinal=1.0)
    public static final class DescriptorImpl
    extends TopLevelItemDescriptor {
        public String getDisplayName() {
            return "Pipeline";
        }

        public TopLevelItem newInstance(ItemGroup parent, String name) {
            return new WorkflowJob(parent, name);
        }

        @Restricted(value={DoNotUse.class})
        public Collection<FlowDefinitionDescriptor> getDefinitionDescriptors(WorkflowJob context) {
            return DescriptorVisibilityFilter.apply((Object)((Object)context), (Iterable)ExtensionList.lookup(FlowDefinitionDescriptor.class));
        }
    }

    @Extension
    public static final class SCMListenerImpl
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) throws Exception {
            if (build instanceof WorkflowRun && pollingBaseline != null) {
                WorkflowJob job = (WorkflowJob)((WorkflowRun)build).getParent();
                if (job.pollingBaselines == null) {
                    job.pollingBaselines = new ConcurrentHashMap();
                }
                job.pollingBaselines.put(scm.getKey(), pollingBaseline);
            }
        }
    }

    public static class BecauseOfBuildInProgress
    extends CauseOfBlockage {
        private final Run<?, ?> build;

        public BecauseOfBuildInProgress(Run<?, ?> build) {
            this.build = build;
        }

        public String getShortDescription() {
            Executor e = this.build.getExecutor();
            String eta = "";
            if (e != null) {
                eta = Messages.BlockedBecauseOfBuildInProgress_ETA(e.getEstimatedRemainingTime());
            }
            int lbn = this.build.getNumber();
            return Messages.BlockedBecauseOfBuildInProgress_shortDescription(lbn, eta);
        }
    }
}

