/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Main;
import hudson.XmlFile;
import hudson.console.AnnotatedLargeText;
import hudson.console.LineTransformationOutputStream;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.util.Iterators;
import hudson.util.NullStream;
import hudson.util.PersistedList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.model.lazy.BuildReference;
import jenkins.model.lazy.LazyBuildMixIn;
import jenkins.model.queue.AsynchronousExecution;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.AfterRestartTask;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.console.WorkflowConsoleLogger;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;
import org.jenkinsci.plugins.workflow.support.steps.input.POSTHyperlinkNote;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

@SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="completed is an unusual usage")
public final class WorkflowRun
extends Run<WorkflowJob, WorkflowRun>
implements FlowExecutionOwner.Executable,
LazyBuildMixIn.LazyLoadingRun<WorkflowJob, WorkflowRun> {
    private static final Logger LOGGER = Logger.getLogger(WorkflowRun.class.getName());
    @Nullable
    private FlowExecution execution;
    private transient SettableFuture<FlowExecution> executionPromise = SettableFuture.create();
    private final transient LazyBuildMixIn.RunMixIn<WorkflowJob, WorkflowRun> runMixIn = new LazyBuildMixIn.RunMixIn<WorkflowJob, WorkflowRun>(){

        protected WorkflowRun asRun() {
            return WorkflowRun.this;
        }
    };
    private transient StreamBuildListener listener;
    private transient AtomicBoolean completed;
    private Map<String, Long> logsToCopy;
    @CheckForNull
    private List<SCMCheckout> checkouts;
    private transient List<ChangeLogSet<? extends ChangeLogSet.Entry>> changeSets;
    private transient boolean firstTime;
    @GuardedBy(value="completed")
    private transient LoadingCache<FlowNode, Optional<String>> logPrefixCache;
    private static final Map<String, WorkflowRun> LOADING_RUNS = new HashMap<String, WorkflowRun>();

    public WorkflowRun(WorkflowJob job) throws IOException {
        super((Job)job);
        this.firstTime = true;
        this.checkouts = new PersistedList((Saveable)this);
    }

    public WorkflowRun(WorkflowJob job, File dir) throws IOException {
        super((Job)job, dir);
    }

    public LazyBuildMixIn.RunMixIn<WorkflowJob, WorkflowRun> getRunMixIn() {
        return this.runMixIn;
    }

    protected BuildReference<WorkflowRun> createReference() {
        return this.getRunMixIn().createReference();
    }

    protected void dropLinks() {
        this.getRunMixIn().dropLinks();
    }

    @Exported
    public WorkflowRun getPreviousBuild() {
        return (WorkflowRun)this.getRunMixIn().getPreviousBuild();
    }

    @Exported
    public WorkflowRun getNextBuild() {
        return (WorkflowRun)this.getRunMixIn().getNextBuild();
    }

    public void run() {
        if (!this.firstTime) {
            throw this.sleep();
        }
        try {
            this.onStartBuilding();
            FileOutputStream logger = new FileOutputStream(this.getLogFile());
            this.listener = new StreamBuildListener((OutputStream)logger, Charset.defaultCharset());
            this.listener.started(this.getCauses());
            RunListener.fireStarted((Run)this, (TaskListener)this.listener);
            this.updateSymlinks((TaskListener)this.listener);
            FlowDefinition definition = ((WorkflowJob)this.getParent()).getDefinition();
            if (definition == null) {
                throw new AbortException("No flow definition, cannot run");
            }
            Owner owner = new Owner(this);
            FlowExecution newExecution = definition.create((FlowExecutionOwner)owner, (TaskListener)this.listener, this.getAllActions());
            FlowExecutionList.get().register((FlowExecutionOwner)owner);
            newExecution.addListener((GraphListener)new GraphL());
            this.completed = new AtomicBoolean();
            this.logsToCopy = new ConcurrentSkipListMap<String, Long>();
            this.execution = newExecution;
            newExecution.start();
            this.executionPromise.set((Object)newExecution);
        }
        catch (Throwable x) {
            this.execution = null;
            this.finish(Result.FAILURE, x);
            this.executionPromise.setException(x);
            return;
        }
        throw this.sleep();
    }

    private AsynchronousExecution sleep() {
        final AsynchronousExecution asynchronousExecution = new AsynchronousExecution(){

            public void interrupt(boolean forShutdown) {
                if (forShutdown) {
                    return;
                }
                try {
                    WorkflowRun.this.execution.interrupt(Result.ABORTED, new CauseOfInterruption[0]);
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
                this.getExecutor().recordCauseOfInterruption((Run)WorkflowRun.this, (TaskListener)WorkflowRun.this.listener);
                WorkflowRun.this.printLater("term", "Click here to forcibly terminate running steps");
            }

            public boolean blocksRestart() {
                return WorkflowRun.this.execution.blocksRestart();
            }

            public boolean displayCell() {
                return this.blocksRestart();
            }
        };
        final AtomicReference copyLogsTask = new AtomicReference();
        copyLogsTask.set(Timer.get().scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicBoolean atomicBoolean = WorkflowRun.this.completed;
                synchronized (atomicBoolean) {
                    if (WorkflowRun.this.completed.get()) {
                        asynchronousExecution.completed(null);
                        ((ScheduledFuture)copyLogsTask.get()).cancel(false);
                        return;
                    }
                    Jenkins jenkins = Jenkins.getInstance();
                    if (jenkins == null || jenkins.isTerminating()) {
                        LOGGER.log(Level.FINE, "shutting down, breaking waitForCompletion on {0}", this);
                        WorkflowRun.this.listener.closeQuietly();
                        WorkflowRun.this.listener = new StreamBuildListener((OutputStream)new NullStream());
                        return;
                    }
                    WorkflowRun.this.copyLogs();
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS));
        return asynchronousExecution;
    }

    private void printLater(final String url, final String message) {
        Timer.get().schedule(new Runnable(){

            @Override
            public void run() {
                if (!WorkflowRun.this.isInProgress()) {
                    return;
                }
                WorkflowRun.this.listener.getLogger().println(POSTHyperlinkNote.encodeTo((String)("/" + WorkflowRun.this.getUrl() + url), (String)message));
            }
        }, 15L, TimeUnit.SECONDS);
    }

    @RequirePOST
    public void doTerm() {
        this.checkPermission(Item.CANCEL);
        if (!this.isInProgress()) {
            return;
        }
        FlowInterruptedException x = new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[0]);
        Futures.addCallback((ListenableFuture)this.execution.getCurrentExecutions(true), (FutureCallback)new FutureCallback<List<StepExecution>>((Throwable)x){
            final /* synthetic */ Throwable val$x;
            {
                this.val$x = throwable;
            }

            public void onSuccess(List<StepExecution> l) {
                for (StepExecution e : Iterators.reverse(l)) {
                    StepContext context = e.getContext();
                    context.onFailure(this.val$x);
                    try {
                        FlowNode n = (FlowNode)context.get(FlowNode.class);
                        if (n == null) continue;
                        WorkflowRun.this.listener.getLogger().println("Terminating " + n.getDisplayFunctionName());
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.FINE, null, x);
                    }
                }
            }

            public void onFailure(Throwable t) {
            }
        });
        this.printLater("kill", "Click here to forcibly kill entire build");
    }

    @RequirePOST
    public void doKill() {
        this.checkPermission(Item.CANCEL);
        if (!this.isBuilding()) {
            return;
        }
        if (this.listener != null) {
            this.listener.getLogger().println("Hard kill!");
        }
        this.execution = null;
        FlowInterruptedException suddenDeath = new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[0]);
        this.finish(Result.ABORTED, (Throwable)suddenDeath);
        this.executionPromise.setException((Throwable)suddenDeath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="completed")
    private void copyLogs() {
        if (this.logsToCopy == null) {
            return;
        }
        if (this.logsToCopy instanceof LinkedHashMap) {
            this.logsToCopy = new ConcurrentSkipListMap<String, Long>(this.logsToCopy);
        }
        boolean modified = false;
        for (Map.Entry<String, Long> entry : this.logsToCopy.entrySet()) {
            FlowNode node;
            String id = entry.getKey();
            try {
                node = this.execution.getNode(id);
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
                this.logsToCopy.remove(id);
                modified = true;
                continue;
            }
            if (node == null) {
                LOGGER.log(Level.WARNING, "no such node {0}", id);
                this.logsToCopy.remove(id);
                modified = true;
                continue;
            }
            LogAction la = (LogAction)node.getAction(LogAction.class);
            if (la != null) {
                AnnotatedLargeText logText = la.getLogText();
                try {
                    long old = entry.getValue();
                    String prefix = this.getLogPrefix(node);
                    Object logger = prefix != null ? new LogLinePrefixOutputFilter(this.listener.getLogger(), "[" + prefix + "] ") : this.listener.getLogger();
                    try {
                        long revised = logText.writeRawLogTo(old, (OutputStream)logger);
                        if (revised != old) {
                            this.logsToCopy.put(id, revised);
                            modified = true;
                        }
                        if (!logText.isComplete()) continue;
                        logText.writeRawLogTo(revised, (OutputStream)logger);
                        assert (!node.isRunning()) : "LargeText.complete yet " + node + " claims to still be running";
                        this.logsToCopy.remove(id);
                        modified = true;
                    }
                    finally {
                        if (prefix != null) {
                            ((LogLinePrefixOutputFilter)((Object)logger)).forceEol();
                        }
                    }
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, null, x);
                    this.logsToCopy.remove(id);
                    modified = true;
                }
                continue;
            }
            if (node.isRunning()) continue;
            this.logsToCopy.remove(id);
            modified = true;
        }
        if (modified) {
            try {
                this.save();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private String getLogPrefix(FlowNode node) {
        AtomicBoolean atomicBoolean = this.completed;
        synchronized (atomicBoolean) {
            if (this.logPrefixCache == null) {
                this.logPrefixCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<FlowNode, Optional<String>>(){

                    @Nonnull
                    public Optional<String> load(FlowNode node) {
                        if (node instanceof BlockEndNode) {
                            return Optional.absent();
                        }
                        ThreadNameAction threadNameAction = (ThreadNameAction)node.getAction(ThreadNameAction.class);
                        if (threadNameAction != null) {
                            return Optional.of((Object)threadNameAction.getThreadName());
                        }
                        for (FlowNode parent : node.getParents()) {
                            String prefix = WorkflowRun.this.getLogPrefix(parent);
                            if (prefix == null) continue;
                            return Optional.of((Object)prefix);
                        }
                        return Optional.absent();
                    }
                });
            }
            return (String)((Optional)this.logPrefixCache.getUnchecked((Object)node)).orNull();
        }
    }

    private String key() {
        return ((WorkflowJob)this.getParent()).getFullName() + '/' + this.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws IOException {
        Map<String, WorkflowRun> map = LOADING_RUNS;
        synchronized (map) {
            LOADING_RUNS.put(this.key(), this);
        }
        new XmlFile(XSTREAM, new File(this.getRootDir(), "build.xml")).unmarshal((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLoad() {
        super.onLoad();
        if (this.completed != null) {
            throw new IllegalStateException("double onLoad of " + (Object)((Object)this));
        }
        if (Main.isUnitTest) {
            System.err.printf("loading %s @%h%n", new Object[]{this, this});
        }
        if (this.execution != null) {
            try {
                this.execution.onLoad((FlowExecutionOwner)new Owner(this));
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
                this.execution = null;
            }
        }
        if (this.execution != null) {
            this.execution.addListener((GraphListener)new GraphL());
            this.executionPromise.set((Object)this.execution);
            if (!this.execution.isComplete()) {
                try {
                    FileOutputStream logger = new FileOutputStream(this.getLogFile(), true);
                    this.listener = new StreamBuildListener((OutputStream)logger, Charset.defaultCharset());
                    this.listener.getLogger().println("Resuming build");
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, null, x);
                    this.listener = new StreamBuildListener((OutputStream)new NullStream());
                }
                this.completed = new AtomicBoolean();
                Timer.get().submit(new Runnable(){

                    @Override
                    public void run() {
                        Queue.getInstance().schedule((Queue.Task)new AfterRestartTask(WorkflowRun.this), 0);
                    }
                });
            }
        }
        this.checkouts(null);
        Map<String, WorkflowRun> map = LOADING_RUNS;
        synchronized (map) {
            LOADING_RUNS.remove(this.key());
            LOADING_RUNS.notifyAll();
        }
    }

    public void setResult(Result r) {
        if (this.result == null || r.isWorseThan(this.result)) {
            this.result = r;
            LOGGER.log(Level.FINE, (Object)((Object)this) + " in " + this.getRootDir() + ": result is set to " + r, LOGGER.isLoggable(Level.FINER) ? new Exception() : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(@Nonnull Result r, @CheckForNull Throwable t) {
        this.setResult(r);
        LOGGER.log(Level.INFO, "{0} completed: {1}", new Object[]{this, this.getResult()});
        if (this.listener == null) {
            LOGGER.log(Level.WARNING, (Object)((Object)this) + " failed to start", t);
        } else {
            RunListener.fireCompleted((Run)this, (TaskListener)this.listener);
            if (t instanceof AbortException) {
                this.listener.error(t.getMessage());
            } else if (t instanceof FlowInterruptedException) {
                ((FlowInterruptedException)t).handle((Run)this, (TaskListener)this.listener);
            } else if (t != null) {
                t.printStackTrace(this.listener.getLogger());
            }
            this.listener.finished(this.getResult());
            this.listener.closeQuietly();
        }
        this.logsToCopy = null;
        this.duration = Math.max(0L, System.currentTimeMillis() - this.getStartTimeInMillis());
        try {
            this.save();
            ((WorkflowJob)this.getParent()).logRotate();
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        this.onEndBuilding();
        if (this.completed != null) {
            AtomicBoolean x = this.completed;
            synchronized (x) {
                this.completed.set(true);
            }
        }
        FlowExecutionList.get().unregister((FlowExecutionOwner)new Owner(this));
        try {
            StashManager.maybeClearAll((Run)this);
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, "failed to clean up stashes from " + (Object)((Object)this), x);
        }
    }

    @CheckForNull
    public FlowExecution getExecution() {
        return this.execution;
    }

    public ListenableFuture<FlowExecution> getExecutionPromise() {
        return this.executionPromise;
    }

    public FlowExecutionOwner asFlowExecutionOwner() {
        return new Owner(this);
    }

    public boolean hasntStartedYet() {
        return this.result == null && this.execution == null;
    }

    public boolean isBuilding() {
        return this.result == null || this.isInProgress();
    }

    @Exported
    protected boolean isInProgress() {
        return this.execution != null && !this.execution.isComplete() && (this.completed == null || !this.completed.get());
    }

    public boolean isLogUpdated() {
        return this.isBuilding();
    }

    @Nonnull
    synchronized List<SCMCheckout> checkouts(@CheckForNull TaskListener listener) {
        if (this.checkouts == null) {
            LOGGER.log(Level.WARNING, "JENKINS-26761: no checkouts in {0}", (Object)this);
            if (listener != null) {
                listener.error("JENKINS-26761: list of SCM checkouts in " + (Object)((Object)this) + " was lost; polling will be broken");
            }
            this.checkouts = new PersistedList((Saveable)this);
        }
        return this.checkouts;
    }

    @Exported
    public synchronized List<ChangeLogSet<? extends ChangeLogSet.Entry>> getChangeSets() {
        if (this.changeSets == null) {
            this.changeSets = new ArrayList<ChangeLogSet<? extends ChangeLogSet.Entry>>();
            for (SCMCheckout co : this.checkouts(null)) {
                if (co.changelogFile == null || !co.changelogFile.isFile()) continue;
                try {
                    ChangeLogSet changeLogSet = co.scm.createChangeLogParser().parse((Run)this, co.scm.getEffectiveBrowser(), co.changelogFile);
                    if (changeLogSet.isEmptySet()) continue;
                    this.changeSets.add((ChangeLogSet<? extends ChangeLogSet.Entry>)changeLogSet);
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "could not parse " + co.changelogFile, x);
                }
            }
        }
        return this.changeSets;
    }

    @RequirePOST
    public synchronized HttpResponse doStop() {
        Executor e = this.getOneOffExecutor();
        if (e != null) {
            return e.doStop();
        }
        this.doKill();
        return HttpResponses.forwardToPreviousPage();
    }

    private void onCheckout(SCM scm, FilePath workspace, TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState pollingBaseline) throws Exception {
        Computer computer;
        if (changelogFile != null && changelogFile.isFile()) {
            ChangeLogSet cls = scm.createChangeLogParser().parse((Run)this, scm.getEffectiveBrowser(), changelogFile);
            if (!cls.isEmptySet()) {
                this.getChangeSets().add((ChangeLogSet<? extends ChangeLogSet.Entry>)cls);
            }
            for (SCMListener l : SCMListener.all()) {
                l.onChangeLogParsed((Run)this, scm, listener, cls);
            }
        }
        if ((computer = workspace.toComputer()) == null) {
            throw new IllegalStateException();
        }
        this.checkouts(listener).add(new SCMCheckout(scm, computer.getName(), workspace.getRemote(), changelogFile, pollingBaseline));
    }

    private void logNodeMessage(FlowNode node) {
        WorkflowConsoleLogger wfLogger = new WorkflowConsoleLogger((BuildListener)this.listener);
        String prefix = this.getLogPrefix(node);
        if (prefix != null) {
            wfLogger.log(String.format("[%s] %s", prefix, node.getDisplayFunctionName()));
        } else {
            wfLogger.log(node.getDisplayFunctionName());
        }
        wfLogger.getLogger().flush();
    }

    static void alias() {
        Run.XSTREAM2.alias("flow-build", WorkflowRun.class);
        new XmlFile(null).getXStream().aliasType("flow-owner", Owner.class);
        Run.XSTREAM2.aliasType("flow-owner", Owner.class);
    }

    @Extension
    public static final class SCMListenerImpl
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) throws Exception {
            if (build instanceof WorkflowRun) {
                ((WorkflowRun)build).onCheckout(scm, workspace, listener, changelogFile, pollingBaseline);
            }
        }
    }

    private final class GraphL
    implements GraphListener {
        private GraphL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNewHead(FlowNode node) {
            AtomicBoolean atomicBoolean = WorkflowRun.this.completed;
            synchronized (atomicBoolean) {
                WorkflowRun.this.copyLogs();
                WorkflowRun.this.logsToCopy.put(node.getId(), 0L);
            }
            node.addAction((Action)new TimingAction());
            WorkflowRun.this.logNodeMessage(node);
            if (node instanceof FlowEndNode) {
                WorkflowRun.this.finish(((FlowEndNode)node).getResult(), WorkflowRun.this.execution.getCauseOfFailure());
            } else {
                try {
                    WorkflowRun.this.save();
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
            }
        }
    }

    private static final class Owner
    extends FlowExecutionOwner {
        private final String job;
        private final String id;
        @CheckForNull
        private transient WorkflowRun run;
        private static final long serialVersionUID = 1L;

        Owner(WorkflowRun run) {
            this.job = ((WorkflowJob)run.getParent()).getFullName();
            this.id = run.getId();
            this.run = run;
        }

        private String key() {
            return this.job + '/' + this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        private WorkflowRun run() throws IOException {
            if (this.run == null) {
                WorkflowRun candidate;
                Map map = LOADING_RUNS;
                synchronized (map) {
                    candidate = (WorkflowRun)((Object)LOADING_RUNS.get(this.key()));
                }
                if (candidate != null && ((WorkflowJob)candidate.getParent()).getFullName().equals(this.job) && candidate.getId().equals(this.id)) {
                    this.run = candidate;
                } else {
                    Jenkins jenkins = Jenkins.getInstance();
                    if (jenkins == null) {
                        throw new IOException("Jenkins is not running");
                    }
                    WorkflowJob j = (WorkflowJob)jenkins.getItemByFullName(this.job, WorkflowJob.class);
                    if (j == null) {
                        throw new IOException("no such WorkflowJob " + this.job);
                    }
                    this.run = (WorkflowRun)j._getRuns().getById(this.id);
                    if (this.run == null) {
                        throw new IOException("no such build " + this.id + " in " + this.job);
                    }
                }
            }
            return this.run;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FlowExecution get() throws IOException {
            WorkflowRun r = this.run();
            Map map = LOADING_RUNS;
            synchronized (map) {
                while (r.execution == null && LOADING_RUNS.containsKey(this.key())) {
                    try {
                        LOADING_RUNS.wait();
                    }
                    catch (InterruptedException x) {
                        LOGGER.log(Level.WARNING, "failed to wait for " + (Object)((Object)r) + " to be loaded", x);
                        break;
                    }
                }
            }
            FlowExecution exec = r.execution;
            if (exec != null) {
                return exec;
            }
            throw new IOException((Object)((Object)r) + " did not yet start");
        }

        public FlowExecution getOrNull() {
            try {
                ListenableFuture<FlowExecution> promise = this.run().getExecutionPromise();
                if (promise.isDone()) {
                    return (FlowExecution)promise.get();
                }
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, null, x);
            }
            return null;
        }

        public File getRootDir() throws IOException {
            return this.run().getRootDir();
        }

        public Queue.Executable getExecutable() throws IOException {
            return this.run();
        }

        public String getUrl() throws IOException {
            return this.run().getUrl();
        }

        public String toString() {
            return "Owner[" + this.key() + ":" + (Object)((Object)this.run) + "]";
        }

        public boolean equals(Object o) {
            if (!(o instanceof Owner)) {
                return false;
            }
            Owner that = (Owner)((Object)o);
            return this.job.equals(that.job) && this.id.equals(that.id);
        }

        public int hashCode() {
            return this.job.hashCode() ^ this.id.hashCode();
        }
    }

    static final class SCMCheckout {
        final SCM scm;
        final String node;
        final String workspace;
        @CheckForNull
        final File changelogFile;
        @CheckForNull
        final SCMRevisionState pollingBaseline;

        SCMCheckout(SCM scm, String node, String workspace, File changelogFile, SCMRevisionState pollingBaseline) {
            this.scm = scm;
            this.node = node;
            this.workspace = workspace;
            this.changelogFile = changelogFile;
            this.pollingBaseline = pollingBaseline;
        }
    }

    private static final class LogLinePrefixOutputFilter
    extends LineTransformationOutputStream {
        private final PrintStream logger;
        private final String prefix;

        protected LogLinePrefixOutputFilter(PrintStream logger, String prefix) {
            this.logger = logger;
            this.prefix = prefix;
        }

        protected void eol(byte[] b, int len) throws IOException {
            this.logger.append(this.prefix);
            this.logger.write(b, 0, len);
        }
    }
}

