/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.console;

import hudson.model.BuildListener;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.jenkinsci.plugins.workflow.job.console.WorkflowMetadataConsoleFilter;

public class WorkflowConsoleLogger {
    private final BuildListener listener;
    private final WorkflowMetadataConsoleFilter annotator;

    public WorkflowConsoleLogger(BuildListener listener) {
        this.listener = listener;
        this.annotator = new WorkflowMetadataConsoleFilter(listener.getLogger());
    }

    public PrintStream getLogger() {
        return this.listener.getLogger();
    }

    public void log(String message) {
        this.logAnnot("[Pipeline] ", message);
    }

    private void logAnnot(String prefix, String message) {
        byte[] msg = String.format("%s%s%n", prefix, message).getBytes(Charset.defaultCharset());
        try {
            this.annotator.eol(msg, msg.length);
        }
        catch (IOException e) {
            this.listener.getLogger().println("Problem with writing into console log: " + e.getMessage());
        }
    }
}

