/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.views;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import jenkins.model.TransientActionFactory;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerResponse;

public final class GraphVizAction
implements Action {
    public final WorkflowRun run;

    private GraphVizAction(WorkflowRun run) {
        this.run = run;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "graphViz";
    }

    public HttpResponse doDot() throws IOException {
        StringWriter sw = new StringWriter();
        this.writeDot(new PrintWriter(sw));
        return HttpResponses.text((String)sw.toString());
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public void doIndex(StaplerResponse rsp) throws IOException {
        Process p = new ProcessBuilder("dot", "-Tpng").start();
        this.writeDot(new PrintWriter(p.getOutputStream()));
        rsp.setContentType("image/png");
        IOUtils.copy((InputStream)p.getInputStream(), (OutputStream)rsp.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDot(PrintWriter w) {
        try {
            w.println("digraph G {");
            FlowGraphWalker walker = new FlowGraphWalker(this.run.getExecution());
            for (FlowNode n : walker) {
                BlockStartNode sn;
                for (FlowNode p : n.getParents()) {
                    w.printf("%s -> %s%n", p.getId(), n.getId());
                }
                if (n instanceof BlockStartNode) {
                    sn = (BlockStartNode)n;
                    w.printf("%s [shape=trapezium]%n", n.getId());
                } else if (n instanceof BlockEndNode) {
                    sn = (BlockEndNode)n;
                    w.printf("%s [shape=invtrapezium]%n", n.getId());
                    w.printf("%s -> %s [style=dotted]%n", sn.getStartNode().getId(), n.getId());
                }
                w.printf("%s [label=\"%s: %s\"]%n", n.getId(), n.getId(), n.getDisplayName());
            }
            w.println("}");
        }
        finally {
            w.close();
        }
    }

    @Extension
    public static final class Factory
    extends TransientActionFactory<WorkflowRun> {
        public Class<WorkflowRun> type() {
            return WorkflowRun.class;
        }

        public Collection<? extends Action> createFor(WorkflowRun run) {
            return Collections.singleton(new GraphVizAction(run));
        }
    }
}

