/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.properties;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Saveable;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.TransientActionFactory;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class PipelineTriggersJobProperty
extends JobProperty<WorkflowJob> {
    private List<Trigger<?>> triggers = new ArrayList();

    @DataBoundConstructor
    public PipelineTriggersJobProperty(List<Trigger<?>> triggers) {
        this.triggers = triggers == null ? new ArrayList() : triggers;
    }

    public void setTriggers(List<Trigger<?>> triggers) {
        this.triggers = triggers;
    }

    public List<Trigger<?>> getTriggers() {
        return this.triggers;
    }

    public void addTrigger(Trigger t) {
        this.triggers.add(t);
    }

    public Trigger getTriggerForDescriptor(TriggerDescriptor td) {
        for (Trigger<?> trigger : this.triggers) {
            if (!td.equals(trigger.getDescriptor())) continue;
            return trigger;
        }
        return null;
    }

    public void stopTriggers() {
        for (Trigger<?> trigger : this.triggers) {
            trigger.stop();
        }
    }

    public void startTriggers(boolean newInstance) {
        for (Trigger<?> trigger : this.triggers) {
            trigger.start((Item)this.owner, newInstance);
        }
    }

    public void removeTrigger(Trigger t) {
        Trigger toRemove = this.getTriggerForDescriptor(t.getDescriptor());
        if (toRemove != null) {
            this.triggers.remove(toRemove);
        }
    }

    public Map<TriggerDescriptor, Trigger<?>> getTriggersMap() {
        HashMap triggerMap = new HashMap();
        for (Trigger<?> t : this.getTriggers()) {
            TriggerDescriptor td = t.getDescriptor();
            triggerMap.put(td, t);
        }
        return triggerMap;
    }

    public List<Action> getAllTriggerActions() {
        ArrayList<Action> triggerActions = new ArrayList<Action>();
        for (Trigger<?> t : this.triggers) {
            triggerActions.addAll(t.getProjectActions());
        }
        return triggerActions;
    }

    @CheckForNull
    public PipelineTriggersJobProperty reconfigure(@Nonnull StaplerRequest req, @CheckForNull JSONObject form) throws Descriptor.FormException {
        DescribableList trigList = new DescribableList(Saveable.NOOP);
        try {
            trigList.rebuild(req, form, Trigger.for_((Item)this.owner));
        }
        catch (IOException e) {
            throw new Descriptor.FormException((Throwable)e, null);
        }
        this.stopTriggers();
        PipelineTriggersJobProperty thisProp = new PipelineTriggersJobProperty(new ArrayList(trigList.toList()));
        thisProp.setOwner(this.owner);
        thisProp.startTriggers(true);
        return thisProp;
    }

    @Extension
    public static class Factory
    extends TransientActionFactory<WorkflowJob> {
        public Class<WorkflowJob> type() {
            return WorkflowJob.class;
        }

        @Nonnull
        public Collection<? extends Action> createFor(@Nonnull WorkflowJob job) {
            return job.getTriggersJobProperty().getAllTriggerActions();
        }
    }

    @Extension
    @Symbol(value={"pipelineTriggers"})
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return "Build triggers";
        }
    }
}

