/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.slaves.WorkspaceList;
import java.io.IOException;
import javax.inject.Inject;
import jenkins.branch.Branch;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.Messages;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.plugins.workflow.steps.scm.GenericSCMStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class ReadTrustedStep
extends AbstractStepImpl {
    private final String path;

    @DataBoundConstructor
    public ReadTrustedStep(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "readTrusted";
        }

        public String getDisplayName() {
            return "Read trusted file from SCM";
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<String> {
        @Inject
        private transient ReadTrustedStep step;
        @StepContextParameter
        private transient Run<?, ?> build;
        @StepContextParameter
        private transient TaskListener listener;
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String run() throws Exception {
            FilePath baseWorkspace;
            Job job = this.build.getParent();
            Jenkins node = Jenkins.getActiveInstance();
            if (job instanceof TopLevelItem) {
                baseWorkspace = node.getWorkspaceFor((TopLevelItem)job);
                if (baseWorkspace == null) {
                    throw new AbortException(node.getDisplayName() + " may be offline");
                }
            } else {
                throw new IllegalStateException(job + " was not top level");
            }
            FilePath dir = this.getFilePathWithSuffix(baseWorkspace);
            FilePath file = dir.child(this.step.path);
            if (!file.absolutize().getRemote().replace('\\', '/').startsWith(dir.absolutize().getRemote().replace('\\', '/') + '/')) {
                throw new IOException(file + " is not inside " + dir);
            }
            Computer computer = node.toComputer();
            if (computer == null) {
                throw new IOException(node.getDisplayName() + " may be offline");
            }
            WorkspaceList.Lease lease = computer.getWorkspaceList().acquire(dir);
            try {
                GenericSCMStep delegate;
                SCMRevision tip;
                BranchJobProperty property = (BranchJobProperty)job.getProperty(BranchJobProperty.class);
                if (property == null) {
                    FlowDefinition defn;
                    if (job instanceof WorkflowJob && (defn = ((WorkflowJob)job).getDefinition()) instanceof CpsScmFlowDefinition) {
                        GenericSCMStep delegate2 = new GenericSCMStep(((CpsScmFlowDefinition)defn).getScm());
                        delegate2.setPoll(true);
                        delegate2.setChangelog(true);
                        delegate2.checkout(this.build, dir, this.listener, node.createLauncher(this.listener));
                        if (!file.exists()) {
                            throw new AbortException(file + " not found");
                        }
                        String string = file.readToString();
                        return string;
                    }
                    throw new IllegalStateException("inappropriate context");
                }
                Branch branch = property.getBranch();
                ItemGroup parent = job.getParent();
                if (!(parent instanceof WorkflowMultiBranchProject)) {
                    throw new IllegalStateException("inappropriate context");
                }
                SCMSource scmSource = ((WorkflowMultiBranchProject)parent).getSCMSource(branch.getSourceId());
                if (scmSource == null) {
                    throw new IllegalStateException(branch.getSourceId() + " not found");
                }
                SCMHead head = branch.getHead();
                SCMRevisionAction action = (SCMRevisionAction)this.build.getAction(SCMRevisionAction.class);
                if (action != null) {
                    tip = action.getRevision();
                } else {
                    tip = scmSource.fetch(head, this.listener);
                    if (tip == null) {
                        throw new AbortException("Could not determine exact tip revision of " + branch.getName());
                    }
                    this.build.addAction((Action)new SCMRevisionAction(tip));
                }
                SCMRevision trusted = scmSource.getTrustedRevision(tip, this.listener);
                String untrustedFile = null;
                if (!tip.equals((Object)trusted)) {
                    delegate = new GenericSCMStep(scmSource.build(head, tip));
                    delegate.setPoll(false);
                    delegate.setChangelog(false);
                    delegate.checkout(this.build, dir, this.listener, node.createLauncher(this.listener));
                    if (!file.exists()) {
                        throw new AbortException(file + " not found");
                    }
                    untrustedFile = file.readToString();
                }
                delegate = new GenericSCMStep(scmSource.build(head, trusted));
                delegate.setPoll(true);
                delegate.setChangelog(true);
                delegate.checkout(this.build, dir, this.listener, node.createLauncher(this.listener));
                if (!file.exists()) {
                    throw new AbortException(file + " not found");
                }
                String content = file.readToString();
                if (untrustedFile != null && !untrustedFile.equals(content)) {
                    throw new AbortException(Messages.ReadTrustedStep__has_been_modified_in_an_untrusted_revis(this.step.path));
                }
                String string = content;
                return string;
            }
            finally {
                lease.release();
            }
        }

        private FilePath getFilePathWithSuffix(FilePath baseWorkspace) {
            return baseWorkspace.withSuffix(this.getFilePathSuffix() + "script");
        }

        private String getFilePathSuffix() {
            return System.getProperty(WorkspaceList.class.getName(), "@");
        }
    }
}

