/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps.scm;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.Messages;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.GitURIRequirementsBuilder;
import org.jenkinsci.plugins.workflow.steps.scm.SCMStep;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public final class GitStep
extends SCMStep {
    private final String url;
    private String branch = "master";
    private String credentialsId;

    @DataBoundConstructor
    public GitStep(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    @Override
    public SCM createSCM() {
        return new GitSCM(GitStep.createRepoList(this.url, this.credentialsId), Collections.singletonList(new BranchSpec("*/" + this.branch)), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.singletonList(new LocalBranch(this.branch)));
    }

    private static List<UserRemoteConfig> createRepoList(String url, String credentialsId) {
        ArrayList<UserRemoteConfig> repoList = new ArrayList<UserRemoteConfig>();
        repoList.add(new UserRemoteConfig(url, null, null, credentialsId));
        return repoList;
    }

    private static StandardCredentials lookupCredentials(Item project, @Nonnull String credentialId, String uri) {
        return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)GitURIRequirementsBuilder.fromUri((String)uri).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends SCMStep.SCMStepDescriptor {
        public DescriptorImpl() {
            GitSCM.class.hashCode();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String url) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().withEmptySelection().withMatching(GitClient.CREDENTIALS_MATCHER, (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)GitURIRequirementsBuilder.fromUri((String)url).build()));
        }

        public FormValidation doCheckUrl(@AncestorInPath Item project, @QueryParameter String credentialsId, @QueryParameter String value) throws IOException, InterruptedException {
            StandardCredentials credentials;
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.error((String)"Please enter repository url.");
            }
            EnvVars environment = new EnvVars(EnvVars.masterEnvVars);
            GitClient git = Git.with((TaskListener)TaskListener.NULL, (EnvVars)environment).using(GitTool.getDefaultInstallation().getGitExe()).getClient();
            if (credentialsId != null && (credentials = GitStep.lookupCredentials(project, credentialsId, url)) != null) {
                git.addDefaultCredentials(credentials);
            }
            try {
                git.getHeadRev(url, "HEAD");
            }
            catch (GitException e) {
                return FormValidation.error((String)Messages.UserRemoteConfig_FailedToConnect((Object)e.getMessage()));
            }
            return FormValidation.ok();
        }

        public String getFunctionName() {
            return "git";
        }

        public String getDisplayName() {
            return "Git";
        }
    }
}

