/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps.scm;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.scm.MultiSCMRevisionState;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class SCMStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(SCMStep.class.getName());
    private boolean poll = true;
    private boolean changelog = true;

    public boolean isPoll() {
        return this.poll;
    }

    @DataBoundSetter
    public void setPoll(boolean poll) {
        this.poll = poll;
    }

    public boolean isChangelog() {
        return this.changelog;
    }

    @DataBoundSetter
    public void setChangelog(boolean changelog) {
        this.changelog = changelog;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new StepExecutionImpl(this, context);
    }

    @NonNull
    protected abstract SCM createSCM();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkout(Run<?, ?> run, FilePath workspace, TaskListener listener, Launcher launcher) throws Exception {
        File changelogFile = null;
        try {
            if (this.changelog) {
                changelogFile = FileSystems.getDefault().supportedFileAttributeViews().contains("posix") ? Files.createTempFile(run.getRootDir().toPath(), "changelog", ".xml", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--"))).toFile() : Files.createTempFile(run.getRootDir().toPath(), "changelog", ".xml", new FileAttribute[0]).toFile();
            }
            Long changelogOriginalModifiedDate = changelogFile != null ? Long.valueOf(changelogFile.lastModified()) : null;
            SCM scm = this.createSCM();
            SCMRevisionState baseline = null;
            Run prev = run.getPreviousBuild();
            if (prev != null) {
                Run run2 = prev;
                synchronized (run2) {
                    MultiSCMRevisionState state = (MultiSCMRevisionState)prev.getAction(MultiSCMRevisionState.class);
                    if (state != null) {
                        baseline = state.get(scm);
                    }
                }
            }
            scm.checkout(run, launcher, workspace, listener, changelogFile, baseline);
            if (changelogFile != null && changelogFile.length() == 0L && changelogOriginalModifiedDate != null && changelogFile.lastModified() == changelogOriginalModifiedDate.longValue()) {
                Files.deleteIfExists(changelogFile.toPath());
                changelogFile = null;
            }
            SCMRevisionState pollingBaseline = null;
            if ((this.poll || this.changelog) && (pollingBaseline = scm.calcRevisionsFromBuild(run, workspace, launcher, listener)) != null) {
                Iterator iterator = run;
                synchronized (iterator) {
                    MultiSCMRevisionState state = (MultiSCMRevisionState)run.getAction(MultiSCMRevisionState.class);
                    if (state == null) {
                        state = new MultiSCMRevisionState();
                        run.addAction((Action)state);
                    }
                    state.add(scm, pollingBaseline);
                }
            }
            for (SCMListener l : SCMListener.all()) {
                try {
                    l.onCheckout(run, scm, workspace, listener, changelogFile, pollingBaseline);
                }
                catch (RuntimeException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
            }
            scm.postCheckout(run, launcher, workspace, listener);
        }
        catch (Exception e) {
            if (changelogFile != null) {
                Files.deleteIfExists(changelogFile.toPath());
            }
            throw e;
        }
    }

    public static abstract class SCMStepDescriptor
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, TaskListener.class, Launcher.class);
        }
    }

    public static final class StepExecutionImpl
    extends SynchronousNonBlockingStepExecution<Map<String, String>> {
        private final transient SCMStep step;
        private static final long serialVersionUID = 1L;

        StepExecutionImpl(SCMStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected Map<String, String> run() throws Exception {
            StepContext ctx = this.getContext();
            Run run = (Run)ctx.get(Run.class);
            this.step.checkout(run, (FilePath)ctx.get(FilePath.class), (TaskListener)ctx.get(TaskListener.class), (Launcher)ctx.get(Launcher.class));
            TreeMap<String, String> envVars = new TreeMap<String, String>();
            this.step.createSCM().buildEnvironment(run, envVars);
            return envVars;
        }
    }
}

