/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.util.concurrent.FutureCallback;
import java.io.Serializable;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public abstract class BodyExecutionCallback
implements Serializable {
    private static final long serialVersionUID = 1L;

    public void onStart(StepContext context) {
    }

    public abstract void onSuccess(StepContext var1, Object var2);

    public abstract void onFailure(StepContext var1, Throwable var2);

    public static BodyExecutionCallback wrap(FutureCallback<Object> v) {
        return v instanceof BodyExecutionCallback ? (BodyExecutionCallback)v : new Wrapper(v);
    }

    public static abstract class TailCall
    extends BodyExecutionCallback {
        private static final long serialVersionUID = 1L;

        protected abstract void finished(StepContext var1) throws Exception;

        @Override
        public final void onSuccess(StepContext context, Object result) {
            try {
                this.finished(context);
                context.onSuccess(result);
            }
            catch (Exception x) {
                context.onFailure(x);
            }
        }

        @Override
        public final void onFailure(StepContext context, Throwable t) {
            try {
                this.finished(context);
                context.onFailure(t);
            }
            catch (Exception x) {
                context.onFailure(x);
            }
        }
    }

    private static class Wrapper
    extends BodyExecutionCallback {
        private final FutureCallback<Object> v;
        private static final long serialVersionUID = 1L;

        public Wrapper(FutureCallback<Object> v) {
            if (!(v instanceof Serializable)) {
                throw new IllegalArgumentException(v.getClass() + " is not serializable");
            }
            this.v = v;
        }

        @Override
        public void onSuccess(StepContext context, Object result) {
            this.v.onSuccess(result);
        }

        @Override
        public void onFailure(StepContext context, Throwable t) {
            this.v.onFailure(t);
        }
    }
}

