/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public abstract class AbstractStepDescriptorImpl
extends StepDescriptor {
    private volatile transient Set<Class<?>> contextTypes;
    private final Class<? extends StepExecution> executionType;

    protected AbstractStepDescriptorImpl(Class<? extends StepExecution> executionType) {
        this.executionType = executionType;
    }

    public final Class<? extends StepExecution> getExecutionType() {
        return this.executionType;
    }

    @Override
    public final Set<Class<?>> getRequiredContext() {
        if (this.contextTypes == null) {
            HashSet r = new HashSet();
            for (Class<? extends StepExecution> c = this.executionType; c != null; c = c.getSuperclass()) {
                for (Field field : c.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(StepContextParameter.class)) continue;
                    r.add(field.getType());
                }
                for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                    if (!accessibleObject.isAnnotationPresent(StepContextParameter.class)) continue;
                    Collections.addAll(r, ((Method)accessibleObject).getParameterTypes());
                }
            }
            this.contextTypes = r;
        }
        return this.contextTypes;
    }
}

