/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.collect.Sets;
import hudson.AbortException;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.CauseOfInterruption;
import jenkins.model.InterruptedBuildAction;

public final class FlowInterruptedException
extends InterruptedException {
    private static final long serialVersionUID = 630482382622970136L;
    @Nonnull
    private final Result result;
    @Nonnull
    private final List<CauseOfInterruption> causes;
    private Boolean actualInterruption = true;

    public FlowInterruptedException(@Nonnull Result result, CauseOfInterruption ... causes) {
        this.result = result;
        this.causes = Arrays.asList(causes);
        this.actualInterruption = true;
    }

    public FlowInterruptedException(@Nonnull Result result, boolean actualInterruption, CauseOfInterruption ... causes) {
        this.result = result;
        this.causes = Arrays.asList(causes);
        this.actualInterruption = actualInterruption;
    }

    @Nonnull
    public Result getResult() {
        return this.result;
    }

    @Nonnull
    public List<CauseOfInterruption> getCauses() {
        return this.causes;
    }

    public boolean isActualInterruption() {
        return this.actualInterruption;
    }

    public void setActualInterruption(boolean actualInterruption) {
        this.actualInterruption = actualInterruption;
    }

    private Object readResolve() {
        if (this.actualInterruption == null) {
            this.actualInterruption = true;
        }
        return this;
    }

    public void handle(Run<?, ?> run, TaskListener listener) {
        HashSet boundCauses = new HashSet();
        for (InterruptedBuildAction a : run.getActions(InterruptedBuildAction.class)) {
            boundCauses.addAll(a.getCauses());
        }
        Sets.SetView diff = Sets.difference(new LinkedHashSet<CauseOfInterruption>(this.causes), boundCauses);
        if (!diff.isEmpty()) {
            run.addAction((Action)new InterruptedBuildAction((Collection)diff));
            for (CauseOfInterruption cause : diff) {
                cause.print(listener);
            }
        }
        FlowInterruptedException.print(this.getCause(), run, listener);
        for (Throwable t : this.getSuppressed()) {
            FlowInterruptedException.print(t, run, listener);
        }
    }

    private static void print(@CheckForNull Throwable t, Run<?, ?> run, @Nonnull TaskListener listener) {
        if (t instanceof AbortException) {
            listener.getLogger().println(t.getMessage());
        } else if (t instanceof FlowInterruptedException) {
            ((FlowInterruptedException)t).handle(run, listener);
        } else if (t != null) {
            Functions.printStackTrace((Throwable)t, (PrintStream)listener.getLogger());
        }
    }
}

