/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.ClassLoaderSanityThreadFactory;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public abstract class SynchronousNonBlockingStepExecution<T>
extends StepExecution {
    private volatile transient Future<?> task;
    private transient String threadName;
    private volatile transient Throwable stopCause;
    private static ExecutorService executorService;

    protected SynchronousNonBlockingStepExecution(@Nonnull StepContext context) {
        super(context);
    }

    protected abstract T run() throws Exception;

    @Override
    public final boolean start() throws Exception {
        Authentication auth = Jenkins.getAuthentication();
        this.task = SynchronousNonBlockingStepExecution.getExecutorService().submit(() -> {
            this.threadName = Thread.currentThread().getName();
            try {
                T ret;
                try (ACLContext acl = ACL.as((Authentication)auth);){
                    ret = this.run();
                }
                this.getContext().onSuccess(ret);
            }
            catch (Throwable x) {
                if (this.stopCause == null) {
                    this.getContext().onFailure(x);
                }
                this.stopCause.addSuppressed(x);
            }
        });
        return false;
    }

    @Override
    public void stop(Throwable cause) throws Exception {
        if (this.task != null) {
            this.stopCause = cause;
            this.task.cancel(true);
        }
        super.stop(cause);
    }

    @Override
    public void onResume() {
        this.getContext().onFailure(new Exception("Resume after a restart not supported for non-blocking synchronous steps"));
    }

    @Override
    @Nonnull
    public String getStatus() {
        if (this.threadName != null) {
            return "running in thread: " + this.threadName;
        }
        return "not yet scheduled";
    }

    @Override
    public boolean blocksRestart() {
        return this.threadName != null;
    }

    static synchronized ExecutorService getExecutorService() {
        if (executorService == null) {
            executorService = Executors.newCachedThreadPool((ThreadFactory)new NamingThreadFactory((ThreadFactory)new ClassLoaderSanityThreadFactory((ThreadFactory)new DaemonThreadFactory()), "org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution"));
        }
        return executorService;
    }
}

