/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.model.Executor;
import hudson.model.Result;
import javax.annotation.Nonnull;
import jenkins.model.CauseOfInterruption;
import org.jenkinsci.plugins.workflow.steps.ExceptionCause;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public abstract class SynchronousStepExecution<T>
extends StepExecution {
    private volatile transient Thread executing;

    protected SynchronousStepExecution(@Nonnull StepContext context) {
        super(context);
    }

    protected abstract T run() throws Exception;

    @Override
    public final boolean start() throws Exception {
        this.executing = Thread.currentThread();
        try {
            this.getContext().onSuccess(this.run());
        }
        catch (Throwable t) {
            this.getContext().onFailure(t);
        }
        finally {
            this.executing = null;
        }
        return true;
    }

    @Override
    public void stop(Throwable cause) throws Exception {
        Thread e = this.executing;
        if (e != null) {
            if (e instanceof Executor) {
                ((Executor)e).interrupt(Result.ABORTED, new CauseOfInterruption[]{new ExceptionCause(cause)});
            } else {
                e.interrupt();
            }
        }
    }
}

